<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Mapper;

use Psr\Http\Message\ResponseInterface as HttpResponseInterface;
use Vtours\ComputopPaymentSdk\Model\RequestInterface;
use Vtours\ComputopPaymentSdk\Model\Response;
use Vtours\ComputopPaymentSdk\Model\ResponseInterface;
use function GuzzleHttp\json_decode;

/**
 * Class ResponseMapperAbstract
 * @package Vtours\ComputopPaymentSdk\Mapper
 */
abstract class ResponseMapperAbstract implements ResponseMapperInterface
{
    /**
     * @inheritDoc
     */
    public abstract function map(HttpResponseInterface $response): Response;

    /**
     * @param HttpResponseInterface $response
     * @return RequestInterface
     */
    protected abstract function mapRequest(HttpResponseInterface $response): RequestInterface;

    /**
     * @param HttpResponseInterface $response
     * @return ResponseInterface
     */
    protected abstract function mapResponse(HttpResponseInterface $response): ResponseInterface;

    /**
     * @param HttpResponseInterface $response
     * @return array
     */
    protected function getResponseBody(HttpResponseInterface $response): array
    {
        $responseBody = (string)$response->getBody();

        return json_decode($responseBody, true);
    }
}
