<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

use Vtours\ComputopPaymentSdk\Exception\ComputopPaymentServiceException;
use Vtours\ComputopPaymentSdk\Model\InitialPayment\Request as RequestInitial;
use Vtours\ComputopPaymentSdk\Model\RecurringPayment\Request as RequestRecurring;
use Vtours\ComputopPaymentSdk\Model\Response;
use Vtours\ComputopPaymentSdk\Service\ComputopSepaPaymentService;

require_once('vendor/autoload.php');

$service = new ComputopSepaPaymentService(
    'http://localhost:8090/'
);

/**
 * @return Response
 * @throws ComputopPaymentServiceException
 */
function sendRequestInitial(): Response
{
    global $service;

    $request = new RequestInitial();
    $request
        ->setAmount(1)
        ->setCurrency('EUR')
        ->setAccountOwner('John Doe')
        ->setIban('DE12500105170648489890')
        ->setBankName('ING')
        ->setMandateId('dasdasfasf')
        ->setDateOfSignature(new DateTime('-3 days'))
        ->setOrderDescription('blabla')
        ->setTransactionId('123456-vtours-15');

    return $service->payAsInitialPayment($request);
}

try {
    $result = sendRequestInitial();
//    var_dump($result);
} catch (ComputopPaymentServiceException $exception) {
    echo print_r($exception, true), PHP_EOL;
}

/**
 * @return Response
 * @throws ComputopPaymentServiceException
 */
function sendRequestRecurring(): Response
{
    global $service;

    $recurringRequest = new RequestRecurring();
    $recurringRequest
        ->setAmount(5)
        ->setOrderDescription('TEST')
        ->setCurrency('EUR')
        ->setPaymentId('dfe6c9c8a9744e2591c20a476e592254');

    return $service->payAsRecurringPayment($recurringRequest);
}

try {
    $result = sendRequestRecurring();
//    var_dump($result);
} catch (ComputopPaymentServiceException $exception) {
    echo print_r($exception, true), PHP_EOL;
}
