<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Model\RecurringPayment;

use DateTime;
use Vtours\ComputopPaymentSdk\Model\ResponseInterface;

/**
 * Class ResponseData
 * @package Vtours\ComputopPaymentSdk\Model\RecurringPayment
 */
class Response implements ResponseInterface
{
    /**
     * @var string|null
     */
    private $mid;

    /**
     * @var string|null
     */
    private $paymentId;

    /**
     * @var string|null
     */
    private $xid;

    /**
     * @var string|null
     */
    private $transactionId;

    /**
     * @var string|null
     */
    private $iban;

    /**
     * @var string|null
     */
    private $accountOwner;

    /**
     * @var string|null
     */
    private $bankName;

    /**
     * @var string|null
     */
    private $mandateId;

    /**
     * @var DateTime|null
     */
    private $dateOfSignature;

    /**
     * @var string|null
     */
    private $mandateSequenceType;

    /**
     * @var string|null
     */
    private $status;

    /**
     * @var int|null
     */
    private $code;

    /**
     * @var string|null
     */
    private $description;

    /**
     * @return string|null
     */
    public function getMid(): ?string
    {
        return $this->mid;
    }

    /**
     * @param string|null $mid
     * @return Response
     */
    public function setMid(?string $mid): Response
    {
        $this->mid = $mid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPaymentId(): ?string
    {
        return $this->paymentId;
    }

    /**
     * @param string|null $paymentId
     * @return Response
     */
    public function setPaymentId(?string $paymentId): Response
    {
        $this->paymentId = $paymentId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getXid(): ?string
    {
        return $this->xid;
    }

    /**
     * @param string|null $xid
     * @return Response
     */
    public function setXid(?string $xid): Response
    {
        $this->xid = $xid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getTransactionId(): ?string
    {
        return $this->transactionId;
    }

    /**
     * @param string|null $transactionId
     * @return Response
     */
    public function setTransactionId(?string $transactionId): Response
    {
        $this->transactionId = $transactionId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getIban(): ?string
    {
        return $this->iban;
    }

    /**
     * @param string|null $iban
     * @return Response
     */
    public function setIban(?string $iban): Response
    {
        $this->iban = $iban;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAccountOwner(): ?string
    {
        return $this->accountOwner;
    }

    /**
     * @param string|null $accountOwner
     * @return Response
     */
    public function setAccountOwner(?string $accountOwner): Response
    {
        $this->accountOwner = $accountOwner;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getBankName(): ?string
    {
        return $this->bankName;
    }

    /**
     * @param string|null $bankName
     * @return Response
     */
    public function setBankName(?string $bankName): Response
    {
        $this->bankName = $bankName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMandateId(): ?string
    {
        return $this->mandateId;
    }

    /**
     * @param string|null $mandateId
     * @return Response
     */
    public function setMandateId(?string $mandateId): Response
    {
        $this->mandateId = $mandateId;
        return $this;
    }

    /**
     * @return DateTime|null
     */
    public function getDateOfSignature(): ?DateTime
    {
        return $this->dateOfSignature;
    }

    /**
     * @param DateTime|null $dateOfSignature
     * @return Response
     */
    public function setDateOfSignature(?DateTime $dateOfSignature): Response
    {
        $this->dateOfSignature = $dateOfSignature;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMandateSequenceType(): ?string
    {
        return $this->mandateSequenceType;
    }

    /**
     * @param string|null $mandateSequenceType
     * @return Response
     */
    public function setMandateSequenceType(?string $mandateSequenceType): Response
    {
        $this->mandateSequenceType = $mandateSequenceType;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * @param string|null $status
     * @return Response
     */
    public function setStatus(?string $status): Response
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getCode(): ?int
    {
        return $this->code;
    }

    /**
     * @param int|null $code
     * @return Response
     */
    public function setCode(?int $code): Response
    {
        $this->code = $code;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDescription(): ?string
    {
        return $this->description;
    }

    /**
     * @param string|null $description
     * @return Response
     */
    public function setDescription(?string $description): Response
    {
        $this->description = $description;
        return $this;
    }

}
