<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Model;

/**
 * Class Response
 * @package Vtours\ComputopPaymentSdk\Model
 */
class Response
{
    /**
     * @var int|null
     */
    private $statusCode;

    /**
     * @var string|null
     */
    private $status;

    /**
     * @var string|null
     */
    private $message;

    /**
     * @var array|string[]|null
     */
    private $errorList;

    /**
     * @var RequestInterface|null
     */
    private $request;

    /**
     * @var ResponseInterface|null
     */
    private $response;

    /**
     * @return int|null
     */
    public function getStatusCode(): ?int
    {
        return $this->statusCode;
    }

    /**
     * @param int|null $statusCode
     * @return Response
     */
    public function setStatusCode(?int $statusCode): Response
    {
        $this->statusCode = $statusCode;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * @param string|null $status
     * @return Response
     */
    public function setStatus(?string $status): Response
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMessage(): ?string
    {
        return $this->message;
    }

    /**
     * @param string|null $message
     * @return Response
     */
    public function setMessage(?string $message): Response
    {
        $this->message = $message;
        return $this;
    }

    /**
     * @return array|string[]|null
     */
    public function getErrorList(): ?array
    {
        return $this->errorList;
    }

    /**
     * @param array|string[]|null $errorList
     * @return Response
     */
    public function setErrorList(?array $errorList)
    {
        $this->errorList = $errorList;
        return $this;
    }

    /**
     * @return RequestInterface|null
     */
    public function getRequest(): ?RequestInterface
    {
        return $this->request;
    }

    /**
     * @param RequestInterface|null $request
     * @return Response
     */
    public function setRequest(?RequestInterface $request): Response
    {
        $this->request = $request;
        return $this;
    }

    /**
     * @return ResponseInterface|null
     */
    public function getResponse(): ?ResponseInterface
    {
        return $this->response;
    }

    /**
     * @param ResponseInterface|null $response
     * @return Response
     */
    public function setResponse(?ResponseInterface $response): Response
    {
        $this->response = $response;
        return $this;
    }
}
