<?php
/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Exception;

use Exception;
use Psr\Http\Message\ResponseInterface as HttpResponseInterface;

/**
 * Class ComputopPaymentServiceException
 * @package Vtours\ComputopPaymentSdk\Exception
 */
class ComputopPaymentServiceException extends Exception
{
    /**
     * @param HttpResponseInterface $response
     * @return ComputopPaymentServiceException
     */
    public static function withMissingResponseData(HttpResponseInterface $response): ComputopPaymentServiceException
    {
        return new self(
            "No Response Body from Computop. HTTP Status code {$response->getStatusCode()}",
            $response->getStatusCode()
        );
    }
}
