<?php
/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Mapper\DirectDebit\Initial;

use Psr\Http\Message\ResponseInterface as HttpResponseInterface;
use Vtours\ComputopPaymentSdk\Exception\ComputopPaymentServiceException;
use Vtours\ComputopPaymentSdk\Mapper\ResponseMapperAbstract;
use Vtours\ComputopPaymentSdk\Model\DirectDebit\Initial\InnerResponse;
use Vtours\ComputopPaymentSdk\Model\DirectDebit\Initial\Request;
use Vtours\ComputopPaymentSdk\Model\PaymentServiceResponse;
use Vtours\ComputopPaymentSdk\Model\RequestInterface as RequestModelInterface;
use Vtours\ComputopPaymentSdk\Model\ResponseInterface as ResponseModelInterface;

/**
 * Class DirectDebitMapperInitial
 * @package Vtours\ComputopPaymentSdk\Mapper\DirectDebit
 */
class DirectDebitMapperInitial extends ResponseMapperAbstract
{
    /**
     * @param HttpResponseInterface $response
     * @return PaymentServiceResponse
     */
    public function map(HttpResponseInterface $response): PaymentServiceResponse
    {
        $responseBody = $this->getResponseBody($response);

        return (new PaymentServiceResponse())
            ->setStatus($responseBody['status'])
            ->setStatusCode($responseBody['status_code'])
            ->setMessage($responseBody['message'])
            ->setRequest($this->mapRequest($response))
            ->setResponse($this->mapResponse($response));
    }

    /**
     * @param HttpResponseInterface $response
     * @return RequestModelInterface
     */
    protected function mapRequest(HttpResponseInterface $response): RequestModelInterface
    {
        $responseBody = $this->getResponseBody($response);

        return (new Request())
            ->setAmount($responseBody['request_data']['amount'] ?? null)
            ->setCurrency($responseBody['request_data']['currency'] ?? null)
            ->setAccountOwner($responseBody['request_data']['account_owner'] ?? null)
            ->setIban($responseBody['request_data']['iban'] ?? null)
            ->setBankName($responseBody['request_data']['bank_name'] ?? null)
            ->setOrderDescription($responseBody['request_data']['order_description'] ?? null)
            ->setDateOfSignature($this->normalizeDateTime($responseBody['request_data']['date_of_signature']))
            ->setMandateId($responseBody['request_data']['mandate_id'] ?? null)
            ->setTransactionId($responseBody['request_data']['transaction_id'] ?? null);
    }

    /**
     * @param HttpResponseInterface $response
     * @return InnerResponse
     * @throws ComputopPaymentServiceException
     */
    protected function mapResponse(HttpResponseInterface $response): ResponseModelInterface
    {
        $responseBody = $this->getResponseBody($response);

        if (empty($responseBody['response_data'])) {
            throw ComputopPaymentServiceException::withMissingResponseData($response);
        }

        return (new InnerResponse())
            ->setMid($responseBody['response_data']['mid'] ?? null)
            ->setPaymentId($responseBody['response_data']['PayID'] ?? null)
            ->setXid($responseBody['response_data']['XID'] ?? null)
            ->setTransactionId($responseBody['response_data']['TransID'] ?? null)
            ->setIban($responseBody['response_data']['IBAN'] ?? null)
            ->setAccountOwner($responseBody['response_data']['AccOwner'] ?? null)
            ->setBankName($responseBody['response_data']['AccBank'] ?? null)
            ->setMandateId($responseBody['response_data']['mandateid'] ?? null)
            ->setDateOfSignature($this->normalizeDateTime($responseBody['response_data']['dtofsgntr']))
            ->setMandateSequenceType($responseBody['response_data']['mdtseqtype'] ?? null)
            ->setStatus($responseBody['response_data']['Status'] ?? null)
            ->setCode($responseBody['response_data']['Code'] ?? null)
            ->setPaymentId($responseBody['response_data']['PayID'] ?? null)
            ->setDescription($responseBody['response_data']['Description'] ?? null);
    }
}
