<?php
/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Model;

use JsonSerializable;

/**
 * Class Request
 * @package Vtours\ComputopPaymentSdk\Model\DirectDebit
 */
class RequestBase implements JsonSerializable, RequestInterface
{
    /**
     * @var float
     */
    protected $amount;

    /**
     * @var string
     */
    protected $currency;

    /**
     * @var string
     */
    protected $orderDescription;

    /**
     * @return float
     */
    public function getAmount(): float
    {
        return $this->amount;
    }

    /**
     * @param float $amount
     * @return RequestBase
     */
    public function setAmount(float $amount): RequestBase
    {
        $this->amount = $amount;
        return $this;
    }

    /**
     * @return string
     */
    public function getCurrency(): string
    {
        return $this->currency;
    }

    /**
     * @param string $currency
     * @return RequestBase
     */
    public function setCurrency(string $currency): RequestBase
    {
        $this->currency = $currency;
        return $this;
    }

    /**
     * @return string
     */
    public function getOrderDescription(): string
    {
        return $this->orderDescription;
    }

    /**
     * @param string $orderDescription
     * @return RequestBase
     */
    public function setOrderDescription(string $orderDescription): RequestBase
    {
        $this->orderDescription = $orderDescription;
        return $this;
    }

    /**
     * @return array
     */
    public function jsonSerialize(): array
    {
        return [
            'amount' => $this->amount,
            'currency' => $this->currency,
            'order_description' => $this->orderDescription,
        ];

    }
}
