<?php
/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Service\DirectDebit;

use GuzzleHttp\Exception\GuzzleException;
use Vtours\ComputopPaymentSdk\Exception\ComputopPaymentServiceException;
use Vtours\ComputopPaymentSdk\Mapper\DirectDebit\Initial\DirectDebitMapperInitial;
use Vtours\ComputopPaymentSdk\Model\DirectDebit\Initial\Request;
use Vtours\ComputopPaymentSdk\Model\PaymentServiceResponse;
use Vtours\ComputopPaymentSdk\Service\PaymentServiceAbstract;

/**
 * Class DirectDebitInitialPaymentService
 * @package Vtours\ComputopPaymentSdk\Service\DirectDebit
 */
class DirectDebitInitialPaymentService extends PaymentServiceAbstract
{
    /**
     * DirectDebitPaymentService constructor.
     * @param string $url
     * @param int|null $timeout
     * @param bool|null $debug
     */
    public function __construct(string $url, ?int $timeout, ?bool $debug)
    {
        parent::__construct(
            $url,
            $timeout,
            $debug,
            new DirectDebitMapperInitial()
        );
    }

    /**
     * @param Request $request
     * @return PaymentServiceResponse
     * @throws ComputopPaymentServiceException
     */
    public function pay(Request $request): PaymentServiceResponse
    {
        try {
            $response = $this->client->request('POST', '/direct-debit/initial', [
                'json' => $request,
            ]);
        } catch (GuzzleException $exception) {
            throw new ComputopPaymentServiceException("An unexpected error occurred: {$exception->getMessage()}", 500, $exception);
        }

        return $this->mapper->map($response);
    }
}
