<?php
/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Service;

use GuzzleHttp\Client;
use Vtours\ComputopPaymentSdk\Mapper\ResponseMapperInterface;

/**
 * Class PaymentServiceAbstract
 * @package Vtours\ComputopPaymentSdk\Service
 */
abstract class PaymentServiceAbstract implements PaymentServiceInterface
{
    /**
     * @var Client
     */
    protected $client;

    /**
     * @var ResponseMapperInterface
     */
    protected $mapper;

    /**
     * ComputopPaymentService constructor.
     * @param string $url
     * @param int|null $timeout
     * @param bool|null $debug
     * @param ResponseMapperInterface $mapper
     */
    public function __construct(string $url, ?int $timeout, ?bool $debug, ResponseMapperInterface $mapper)
    {
        $this->client = new Client([
            'base_uri' => $url,
            'timeout' => $timeout ?? 60,
            'debug' => $debug ?? false,
        ]);
        $this->mapper = $mapper;
    }
}
