<?php
/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Model\CreditCard\Recurring;

use Vtours\ComputopPaymentSdk\Model\RequestBase as RequestBase;

/**
 * Class Request
 * @package Vtours\ComputopPaymentSdk\Model\CreditCard\Recurring
 */
class Request extends RequestBase
{
    /**
     * @var string|null
     */
    private $accountOwner;

    /**
     * @var string
     */
    private $addressCountry;

    /**
     * @var string
     */
    private $cardNumber;

    /**
     * @var string|null
     */
    private $cardExpiryDate;

    /**
     * @var string
     */
    private $cardBrand;

    /**
     * @var string|null
     */
    private $cardHolderName;

    /**
     * @var string|null
     */
    private $cardHolderCountry;

    /**
     * @var string|null
     */
    private $cardHolderCity;

    /**
     * @var string|null
     */
    private $schemeReferenceId;

    /**
     * @return array
     */
    public function jsonSerialize(): array
    {
        return array_replace([
            'account_owner' => $this->accountOwner,
            'address_country' => $this->addressCountry,
            'card_number' => $this->cardNumber,
            'card_expiry_date' => $this->cardExpiryDate,
            'card_brand' => $this->cardBrand,
            'card_holder_name' => $this->cardHolderName,
            'card_holder_country' => $this->cardHolderCountry,
            'card_holder_city' => $this->cardHolderCity,
            'scheme_reference_id' => $this->schemeReferenceId,
        ], parent::jsonSerialize());
    }

    /**
     * @return string|null
     */
    public function getAccountOwner(): ?string
    {
        return $this->accountOwner;
    }

    /**
     * @param string|null $accountOwner
     * @return Request
     */
    public function setAccountOwner(?string $accountOwner): Request
    {
        $this->accountOwner = $accountOwner;
        return $this;
    }

    /**
     * @return string
     */
    public function getAddressCountry(): string
    {
        return $this->addressCountry;
    }

    /**
     * @param string $addressCountry
     * @return Request
     */
    public function setAddressCountry(string $addressCountry): Request
    {
        $this->addressCountry = $addressCountry;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardNumber(): string
    {
        return $this->cardNumber;
    }

    /**
     * @param string $cardNumber
     * @return Request
     */
    public function setCardNumber(string $cardNumber): Request
    {
        $this->cardNumber = $cardNumber;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCardExpiryDate(): ?string
    {
        return $this->cardExpiryDate;
    }

    /**
     * @param string|null $cardExpiryDate
     * @return Request
     */
    public function setCardExpiryDate(?string $cardExpiryDate): Request
    {
        $this->cardExpiryDate = $cardExpiryDate;
        return $this;
    }

    /**
     * @return string
     */
    public function getCardBrand(): string
    {
        return $this->cardBrand;
    }

    /**
     * @param string $cardBrand
     * @return Request
     */
    public function setCardBrand(string $cardBrand): Request
    {
        $this->cardBrand = $cardBrand;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCardHolderName(): ?string
    {
        return $this->cardHolderName;
    }

    /**
     * @param string|null $cardHolderName
     * @return Request
     */
    public function setCardHolderName(?string $cardHolderName): Request
    {
        $this->cardHolderName = $cardHolderName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCardHolderCountry(): ?string
    {
        return $this->cardHolderCountry;
    }

    /**
     * @param string|null $cardHolderCountry
     * @return Request
     */
    public function setCardHolderCountry(?string $cardHolderCountry): Request
    {
        $this->cardHolderCountry = $cardHolderCountry;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCardHolderCity(): ?string
    {
        return $this->cardHolderCity;
    }

    /**
     * @param string|null $cardHolderCity
     * @return Request
     */
    public function setCardHolderCity(?string $cardHolderCity): Request
    {
        $this->cardHolderCity = $cardHolderCity;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSchemeReferenceId(): ?string
    {
        return $this->schemeReferenceId;
    }

    /**
     * @param string|null $schemeReferenceId
     * @return Request
     */
    public function setSchemeReferenceId(?string $schemeReferenceId): Request
    {
        $this->schemeReferenceId = $schemeReferenceId;
        return $this;
    }
}
