<?php
/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Model\DirectDebit\Initial;

use DateTime;
use Vtours\ComputopPaymentSdk\Model\InnerResponseBase;

/**
 * Class Response
 * @package Vtours\ComputopPaymentSdk\Model\DirectDebit\Initial
 */
class InnerResponse extends InnerResponseBase
{
    /**
     * @var string|null
     */
    private $iban;

    /**
     * @var string|null
     */
    private $accountOwner;

    /**
     * @var string|null
     */
    private $bankName;

    /**
     * @var string|null
     */
    private $mandateId;

    /**
     * @var DateTime|null
     */
    private $dateOfSignature;

    /**
     * @var string|null
     */
    private $mandateSequenceType;

    /**
     * @return string|null
     */
    public function getIban(): ?string
    {
        return $this->iban;
    }

    /**
     * @param string|null $iban
     * @return InnerResponse
     */
    public function setIban(?string $iban): InnerResponse
    {
        $this->iban = $iban;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAccountOwner(): ?string
    {
        return $this->accountOwner;
    }

    /**
     * @param string|null $accountOwner
     * @return InnerResponse
     */
    public function setAccountOwner(?string $accountOwner): InnerResponse
    {
        $this->accountOwner = $accountOwner;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getBankName(): ?string
    {
        return $this->bankName;
    }

    /**
     * @param string|null $bankName
     * @return InnerResponse
     */
    public function setBankName(?string $bankName): InnerResponse
    {
        $this->bankName = $bankName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMandateId(): ?string
    {
        return $this->mandateId;
    }

    /**
     * @param string|null $mandateId
     * @return InnerResponse
     */
    public function setMandateId(?string $mandateId): InnerResponse
    {
        $this->mandateId = $mandateId;
        return $this;
    }

    /**
     * @return DateTime|null
     */
    public function getDateOfSignature(): ?DateTime
    {
        return $this->dateOfSignature;
    }

    /**
     * @param DateTime|null $dateOfSignature
     * @return InnerResponse
     */
    public function setDateOfSignature(?DateTime $dateOfSignature): InnerResponse
    {
        $this->dateOfSignature = $dateOfSignature;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMandateSequenceType(): ?string
    {
        return $this->mandateSequenceType;
    }

    /**
     * @param string|null $mandateSequenceType
     * @return InnerResponse
     */
    public function setMandateSequenceType(?string $mandateSequenceType): InnerResponse
    {
        $this->mandateSequenceType = $mandateSequenceType;
        return $this;
    }
}
