<?php
/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Model\DirectDebit\Recurring;

use Vtours\ComputopPaymentSdk\Model\RequestBase as RequestBase;

/**
 * Class Request
 * @package Vtours\ComputopPaymentSdk\Model\DirectDebit\Recurring
 */
class Request extends RequestBase
{
    /**
     * @var string
     */
    private $paymentId;

    /**
     * @return string
     */
    public function getPaymentId(): string
    {
        return $this->paymentId;
    }

    /**
     * @param string $paymentId
     * @return Request
     */
    public function setPaymentId(string $paymentId): Request
    {
        $this->paymentId = $paymentId;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function jsonSerialize(): array
    {
        return array_replace([
            'payment_id' => $this->paymentId,
        ], parent::jsonSerialize());
    }
}
