<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */


use Vtours\ComputopPaymentSdk\Exception\ComputopPaymentServiceException;
use Vtours\ComputopPaymentSdk\Model\DirectDebit\Recurring\Request;
use Vtours\ComputopPaymentSdk\Model\PaymentServiceResponse;
use Vtours\ComputopPaymentSdk\Service\DirectDebit\DirectDebitRecurringPaymentService;

require_once("../../vendor/autoload.php");

$service = new DirectDebitRecurringPaymentService(
    'http://localhost:8082/',
    60
);


/**
 * @return PaymentServiceResponse
 * @throws ComputopPaymentServiceException
 */
function sendRequestRecurring(): PaymentServiceResponse
{
    global $service;

    $request = new Request();
    $request
        ->setAmount(1)
        ->setOrderDescription('test:0000')
        ->setCurrency('EUR')
        ->setPaymentId('685b0d5ca5e140bcbbbf0dc963ef9dab');

    return $service->pay($request);
}

try {
    $result = sendRequestRecurring();
    var_dump($result);
} catch (ComputopPaymentServiceException $exception) {
    echo print_r($exception, true), PHP_EOL;
}
