<?php
/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Model\DirectDebit\Initial;

use DateTime;
use Vtours\ComputopPaymentSdk\Model\RequestBase as RequestBase;

/**
 * Class Request
 * @package Vtours\ComputopPaymentSdk\Model\DirectDebit\Initial
 */
class Request extends RequestBase
{
    /**
     * @var string
     */
    private $accountOwner;

    /**
     * @var string
     */
    private $iban;

    /**
     * @var string
     */
    private $bankName;

    /**
     * @var DateTime
     */
    private $dateOfSignature;

    /**
     * @var string
     */
    private $mandateId;

    /**
     * @inheritDoc
     */
    public function jsonSerialize(): array
    {
        return array_replace([
            'account_owner' => $this->accountOwner,
            'iban' => $this->iban,
            'bank_name' => $this->bankName,
            'date_of_signature' => $this->dateOfSignature->format('d.m.Y'),
            'mandate_id' => $this->mandateId,
        ], parent::jsonSerialize());
    }

    /**
     * @return string
     */
    public function getAccountOwner(): string
    {
        return $this->accountOwner;
    }

    /**
     * @param string $accountOwner
     * @return Request
     */
    public function setAccountOwner(string $accountOwner): Request
    {
        $this->accountOwner = $accountOwner;
        return $this;
    }

    /**
     * @return string
     */
    public function getIban(): string
    {
        return $this->iban;
    }

    /**
     * @param string $iban
     * @return Request
     */
    public function setIban(string $iban): Request
    {
        $this->iban = $iban;
        return $this;
    }

    /**
     * @return string
     */
    public function getBankName(): string
    {
        return $this->bankName;
    }

    /**
     * @param string $bankName
     * @return Request
     */
    public function setBankName(string $bankName): Request
    {
        $this->bankName = $bankName;
        return $this;
    }

    /**
     * @return DateTime
     */
    public function getDateOfSignature(): DateTime
    {
        return $this->dateOfSignature;
    }

    /**
     * @param DateTime $dateOfSignature
     * @return Request
     */
    public function setDateOfSignature(DateTime $dateOfSignature): Request
    {
        $this->dateOfSignature = $dateOfSignature;
        return $this;
    }

    /**
     * @return string
     */
    public function getMandateId(): string
    {
        return $this->mandateId;
    }

    /**
     * @param string $mandateId
     * @return Request
     */
    public function setMandateId(string $mandateId): Request
    {
        $this->mandateId = $mandateId;
        return $this;
    }
}
