<?php
/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Model;

/**
 * Class Response
 * @package Vtours\ComputopPaymentSdk\Model\DirectDebit
 */
class InnerResponseBase implements ResponseInterface
{
    /**
     * @var string|null
     */
    private $mid;

    /**
     * @var string|null
     */
    private $paymentId;

    /**
     * @var string|null
     */
    private $xid;

    /**
     * @var string|null
     */
    private $transactionId;

    /**
     * @var string|null
     */
    private $status;

    /**
     * @var int|null
     */
    private $code;

    /**
     * @var string|null
     */
    private $description;

    /**
     * @return string|null
     */
    public function getMid(): ?string
    {
        return $this->mid;
    }

    /**
     * @param string|null $mid
     * @return InnerResponseBase
     */
    public function setMid(?string $mid): InnerResponseBase
    {
        $this->mid = $mid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPaymentId(): ?string
    {
        return $this->paymentId;
    }

    /**
     * @param string|null $paymentId
     * @return InnerResponseBase
     */
    public function setPaymentId(?string $paymentId): InnerResponseBase
    {
        $this->paymentId = $paymentId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getXid(): ?string
    {
        return $this->xid;
    }

    /**
     * @param string|null $xid
     * @return InnerResponseBase
     */
    public function setXid(?string $xid): InnerResponseBase
    {
        $this->xid = $xid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getTransactionId(): ?string
    {
        return $this->transactionId;
    }

    /**
     * @param string|null $transactionId
     * @return InnerResponseBase
     */
    public function setTransactionId(?string $transactionId): InnerResponseBase
    {
        $this->transactionId = $transactionId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * @param string|null $status
     * @return InnerResponseBase
     */
    public function setStatus(?string $status): InnerResponseBase
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getCode(): ?int
    {
        return $this->code;
    }

    /**
     * @param int|null $code
     * @return InnerResponseBase
     */
    public function setCode(?int $code): InnerResponseBase
    {
        $this->code = $code;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDescription(): ?string
    {
        return $this->description;
    }

    /**
     * @param string|null $description
     * @return InnerResponseBase
     */
    public function setDescription(?string $description): InnerResponseBase
    {
        $this->description = $description;
        return $this;
    }

}
