<?php
/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Model;

/**
 * Class Response
 * @package Vtours\ComputopPaymentSdk\Model
 */
class PaymentServiceResponse implements ResponseInterface
{
    /**
     * @var int|null
     */
    private $statusCode;

    /**
     * @var string|null
     */
    private $status;

    /**
     * @var string|null
     */
    private $message;

    /**
     * @var array|string[]|null
     */
    private $errorList;

    /**
     * @var RequestInterface|null
     */
    private $request;

    /**
     * @var ResponseInterface|null
     */
    private $response;

    /**
     * @return int|null
     */
    public function getStatusCode(): ?int
    {
        return $this->statusCode;
    }

    /**
     * @param int|null $statusCode
     * @return PaymentServiceResponse
     */
    public function setStatusCode(?int $statusCode): PaymentServiceResponse
    {
        $this->statusCode = $statusCode;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * @param string|null $status
     * @return PaymentServiceResponse
     */
    public function setStatus(?string $status): PaymentServiceResponse
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMessage(): ?string
    {
        return $this->message;
    }

    /**
     * @param string|null $message
     * @return PaymentServiceResponse
     */
    public function setMessage(?string $message): PaymentServiceResponse
    {
        $this->message = $message;
        return $this;
    }

    /**
     * @return array|string[]|null
     */
    public function getErrorList(): ?array
    {
        return $this->errorList;
    }

    /**
     * @param array|string[]|null $errorList
     * @return PaymentServiceResponse
     */
    public function setErrorList(?array $errorList): PaymentServiceResponse
    {
        $this->errorList = $errorList;
        return $this;
    }

    /**
     * @return RequestInterface|null
     */
    public function getRequest(): ?RequestInterface
    {
        return $this->request;
    }

    /**
     * @param RequestInterface|null $request
     * @return PaymentServiceResponse
     */
    public function setRequest(?RequestInterface $request): PaymentServiceResponse
    {
        $this->request = $request;
        return $this;
    }

    /**
     * @return ResponseInterface|null
     */
    public function getResponse(): ?ResponseInterface
    {
        return $this->response;
    }

    /**
     * @param ResponseInterface|null $response
     * @return PaymentServiceResponse
     */
    public function setResponse(?ResponseInterface $response): PaymentServiceResponse
    {
        $this->response = $response;
        return $this;
    }
}
