<?php
/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Model;

use DateTime;
use JsonSerializable;

/**
 * Class Request
 * @package Vtours\ComputopPaymentSdk\Model\DirectDebit
 */
class RequestBase implements JsonSerializable, RequestInterface
{
    /**
     * @var float
     */
    protected $amount;

    /**
     * @var string
     */
    protected $currency;

    /**
     * @var string
     */
    protected $orderDescription;

    /**
     * @var string
     */
    protected $referenceNumber;

    /**
     * @var string
     */
    private $transactionId;

    /**
     * @var string|null
     */
    private $accountOwner;

    /**
     * @var string
     */
    private $iban;

    /**
     * @var string
     */
    private $bankName;

    /**
     * @var DateTime
     */
    private $dateOfSignature;

    /**
     * @var string
     */
    private $mandateId;

    /**
     * @var string|null
     */
    private $mandateSequenceType;

    /**
     * @return float
     */
    public function getAmount(): float
    {
        return $this->amount;
    }

    /**
     * @param float $amount
     * @return RequestBase
     */
    public function setAmount(float $amount): RequestBase
    {
        $this->amount = $amount;
        return $this;
    }

    /**
     * @return string
     */
    public function getCurrency(): string
    {
        return $this->currency;
    }

    /**
     * @param string $currency
     * @return RequestBase
     */
    public function setCurrency(string $currency): RequestBase
    {
        $this->currency = $currency;
        return $this;
    }

    /**
     * @return string
     */
    public function getOrderDescription(): string
    {
        return $this->orderDescription;
    }

    /**
     * @param string $orderDescription
     * @return RequestBase
     */
    public function setOrderDescription(string $orderDescription): RequestBase
    {
        $this->orderDescription = $orderDescription;
        return $this;
    }

    /**
     * @return string
     */
    public function getReferenceNumber(): string
    {
        return $this->referenceNumber;
    }

    /**
     * @param string $referenceNumber
     * @return RequestBase
     */
    public function setReferenceNumber(string $referenceNumber): RequestBase
    {
        $this->referenceNumber = $referenceNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getTransactionId(): string
    {
        return $this->transactionId;
    }

    /**
     * @param string $transactionId
     * @return RequestBase
     */
    public function setTransactionId(string $transactionId): RequestBase
    {
        $this->transactionId = $transactionId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAccountOwner(): ?string
    {
        return $this->accountOwner;
    }

    /**
     * @param string|null $accountOwner
     * @return RequestBase
     */
    public function setAccountOwner(?string $accountOwner): RequestBase
    {
        $this->accountOwner = $accountOwner;
        return $this;
    }

    /**
     * @return string
     */
    public function getIban(): string
    {
        return $this->iban;
    }

    /**
     * @param string $iban
     * @return RequestBase
     */
    public function setIban(string $iban): RequestBase
    {
        $this->iban = $iban;
        return $this;
    }

    /**
     * @return string
     */
    public function getBankName(): string
    {
        return $this->bankName;
    }

    /**
     * @param string $bankName
     * @return RequestBase
     */
    public function setBankName(string $bankName): RequestBase
    {
        $this->bankName = $bankName;
        return $this;
    }

    /**
     * @return DateTime
     */
    public function getDateOfSignature(): DateTime
    {
        return $this->dateOfSignature;
    }

    /**
     * @param DateTime $dateOfSignature
     * @return RequestBase
     */
    public function setDateOfSignature(DateTime $dateOfSignature): RequestBase
    {
        $this->dateOfSignature = $dateOfSignature;
        return $this;
    }

    /**
     * @return string
     */
    public function getMandateId(): string
    {
        return $this->mandateId;
    }

    /**
     * @param string $mandateId
     * @return RequestBase
     */
    public function setMandateId(string $mandateId): RequestBase
    {
        $this->mandateId = $mandateId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMandateSequenceType(): ?string
    {
        return $this->mandateSequenceType;
    }

    /**
     * @param string|null $mandateSequenceType
     * @return RequestBase
     */
    public function setMandateSequenceType(?string $mandateSequenceType): RequestBase
    {
        $this->mandateSequenceType = $mandateSequenceType;
        return $this;
    }

    /**
     * @return array
     */
    public function jsonSerialize(): array
    {
        return array_filter([
            'amount' => $this->amount,
            'currency' => $this->currency,
            'order_description' => $this->orderDescription,
            'reference_number' => $this->referenceNumber,
            'transaction_id' => $this->transactionId,
            'account_owner' => $this->accountOwner,
            'iban' => $this->iban,
            'bank_name' => $this->bankName,
            'date_of_signature' => $this->dateOfSignature->format('d.m.Y'),
            'mandate_id' => $this->mandateId,
            'mandate_sequence_type' => $this->mandateSequenceType
        ]);

    }
}
