<?php
/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Service\DirectDebit;

use GuzzleHttp\Exception\RequestException;
use Throwable;
use Vtours\ComputopPaymentSdk\Exception\ComputopPaymentServiceException;
use Vtours\ComputopPaymentSdk\Mapper\DirectDebit\Recurring\DirectDebitMapperRecurring;
use Vtours\ComputopPaymentSdk\Model\DirectDebit\Recurring\Request;
use Vtours\ComputopPaymentSdk\Model\PaymentServiceResponse;
use Vtours\ComputopPaymentSdk\Service\PaymentServiceAbstract;

/**
 * Class DirectDebitRecurringPaymentService
 * @package Vtours\ComputopPaymentSdk\Service\DirectDebit
 */
class DirectDebitRecurringPaymentService extends PaymentServiceAbstract
{
    /**
     * DirectDebitRecurringPaymentService constructor.
     * @param string $url
     * @param int|null $timeout
     * @param bool|null $debug
     */
    public function __construct(string $url, ?int $timeout, ?bool $debug)
    {
        parent::__construct(
            $url,
            $timeout,
            $debug,
            new DirectDebitMapperRecurring()
        );
    }

    /**
     * @param Request $request
     * @return PaymentServiceResponse
     * @throws ComputopPaymentServiceException
     */
    public function pay(Request $request): PaymentServiceResponse
    {
        try {
            return $this->mapper->map(
                $this->client->request('POST', '/direct-debit/recurring', [
                    'json' => $request,
                ])
            );
        } catch (Throwable $exception) {
            if ($exception instanceof RequestException && $exception->hasResponse()) {
                return $this->mapper->map($exception->getResponse());
            }
            throw new ComputopPaymentServiceException("Payment Service Exception: {$exception->getMessage()}", $exception->getCode(), $exception);
        }
    }
}
