<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */


use Vtours\ComputopPaymentSdk\Exception\ComputopPaymentServiceException;
use Vtours\ComputopPaymentSdk\Model\PaymentServiceResponse;

require_once("../../vendor/autoload.php");

$service = new \Vtours\ComputopPaymentSdk\Service\DirectDebit\DirectDebitInitialPaymentService(
    'http://localhost:8082/',
    60
);

/**
 * @return PaymentServiceResponse
 * @throws \Vtours\ComputopPaymentSdk\Exception\ComputopPaymentServiceException
 */
function sendRequestInitial(): PaymentServiceResponse
{
    global $service;

    $request = new \Vtours\ComputopPaymentSdk\Model\DirectDebit\Initial\Request();
    $request
        ->setAmount(100)
        ->setCurrency('EUR')
        ->setAccountOwner('John Doe')
        ->setIban('DE12500105170648489890')
        ->setBankName('ING')
        ->setMandateId('dasdasfasf')
        ->setDateOfSignature(new DateTime('-3 days'))
        ->setOrderDescription('test:0000')
        ->setTransactionId('123456-vtours-15');

    return $service->pay($request);
}

try {
    $result = sendRequestInitial();
    var_dump($result);
} catch (ComputopPaymentServiceException $exception) {
    echo print_r($exception, true), PHP_EOL;
}
