<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */


use Vtours\ComputopPaymentSdk\Exception\ComputopPaymentServiceException;
use Vtours\ComputopPaymentSdk\Model\CreditCard\Recurring\Request;
use Vtours\ComputopPaymentSdk\Model\PaymentServiceResponse;
use Vtours\ComputopPaymentSdk\Service\CreditCard\CreditCardRecurringPaymentService;

require_once("../../vendor/autoload.php");

$service = new CreditCardRecurringPaymentService(
    'http://localhost:8082/',
    60
);


/**
 * @return PaymentServiceResponse
 * @throws ComputopPaymentServiceException
 */
function sendRequestRecurring(): PaymentServiceResponse
{
    global $service;

    $request = new Request();
    $request
        ->setAmount(1)
        ->setCurrency('EUR')
        ->setOrderDescription('test:0000')
        ->setAccountOwner('John Doe')
        ->setAddressCountry('DE')
        ->setCardHolderName('John Doe')
        ->setCardHolderCity('city name')
        ->setCardHolderCountry('DE')
        ->setCardBrand('VISA')
        ->setCardNumber('0973538436137469')
        ->setCardExpiryDate('202201')
        ->setSchemeReferenceId(null);

    return $service->pay($request);
}

try {
    $result = sendRequestRecurring();
    var_dump($result);
} catch (ComputopPaymentServiceException $exception) {
    echo print_r($exception, true), PHP_EOL;
}
