<?php
/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Model\CreditCard\Initial;

use Vtours\ComputopPaymentSdk\Model\InnerResponseBase;

/**
 * Class InnerResponse
 * @package Vtours\ComputopPaymentSdk\Model\CreditCard\Initial
 */
class InnerResponse extends InnerResponseBase
{
    /**
     * @var string|null
     */
    private $referenceNumber;

    /**
     * @var string|null
     */
    private $card;

    /**
     * @var string|null
     */
    private $schemeReferenceId;

    /**
     * @return string|null
     */
    public function getReferenceNumber(): ?string
    {
        return $this->referenceNumber;
    }

    /**
     * @param string|null $referenceNumber
     * @return InnerResponse
     */
    public function setReferenceNumber(?string $referenceNumber): InnerResponse
    {
        $this->referenceNumber = $referenceNumber;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCard(): ?string
    {
        return $this->card;
    }

    /**
     * @param string|null $card
     * @return InnerResponse
     */
    public function setCard(?string $card): InnerResponse
    {
        $this->card = $card;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSchemeReferenceId(): ?string
    {
        return $this->schemeReferenceId;
    }

    /**
     * @param string|null $schemeReferenceId
     * @return InnerResponse
     */
    public function setSchemeReferenceId(?string $schemeReferenceId): InnerResponse
    {
        $this->schemeReferenceId = $schemeReferenceId;
        return $this;
    }
}
