<?php
/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 *  @copyright 2021 Lifestyle Webconsulting GmbH
 *  @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Model\CreditCard;

/**
 * Class ThreeDsData
 * @package Vtours\ComputopPaymentSdk\Model\CreditCard
 */
class ThreeDsData
{
    /**
     * @var string
     */
    private $protocolVersion;

    /**
     * @var string
     */
    private $authenticationValue;

    /**
     * @var string
     */
    private $eci;

    /**
     * @var string|null
     */
    private $serverTransId;

    /**
     * @var string|null
     */
    private $acsXid;

    /**
     * @var string|null
     */
    private $dsTransId;

    /**
     * @return string
     */
    public function getProtocolVersion(): string
    {
        return $this->protocolVersion;
    }

    /**
     * @param string $protocolVersion
     * @return ThreeDsData
     */
    public function setProtocolVersion(string $protocolVersion): ThreeDsData
    {
        $this->protocolVersion = $protocolVersion;
        return $this;
    }

    /**
     * @return string
     */
    public function getAuthenticationValue(): string
    {
        return $this->authenticationValue;
    }

    /**
     * @param string $authenticationValue
     * @return ThreeDsData
     */
    public function setAuthenticationValue(string $authenticationValue): ThreeDsData
    {
        $this->authenticationValue = $authenticationValue;
        return $this;
    }

    /**
     * @return string
     */
    public function getEci(): string
    {
        return $this->eci;
    }

    /**
     * @param string $eci
     * @return ThreeDsData
     */
    public function setEci(string $eci): ThreeDsData
    {
        $this->eci = $eci;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getServerTransId(): ?string
    {
        return $this->serverTransId;
    }

    /**
     * @param string|null $serverTransId
     * @return ThreeDsData
     */
    public function setServerTransId(?string $serverTransId): ThreeDsData
    {
        $this->serverTransId = $serverTransId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAcsXid(): ?string
    {
        return $this->acsXid;
    }

    /**
     * @param string|null $acsXid
     * @return ThreeDsData
     */
    public function setAcsXid(?string $acsXid): ThreeDsData
    {
        $this->acsXid = $acsXid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDsTransId(): ?string
    {
        return $this->dsTransId;
    }

    /**
     * @param string|null $dsTransId
     * @return ThreeDsData
     */
    public function setDsTransId(?string $dsTransId): ThreeDsData
    {
        $this->dsTransId = $dsTransId;
        return $this;
    }
}
