<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Mapper;

use DateTime;
use Vtours\ComputopPaymentSdk\Model\InitialPayment\Request;
use Vtours\ComputopPaymentSdk\Model\InitialPayment\Response;
use Vtours\ComputopPaymentSdk\Model\InitialPayment\ResponseData;

/**
 * Class ResponseMapper
 * @package Vtours\ComputopPaymentSdk\Mapper
 */
class ResponseMapper
{
    /**
     * @param array $responseBody
     * @return Response
     */
    public function map($responseBody)
    {
        $response = new Response();

        $requestData = new Request();
        $requestData
            ->setAmount($responseBody['request_data']['amount'])
            ->setCurrency($responseBody['request_data']['currency'])
            ->setAccountOwner($responseBody['request_data']['account_owner'])
            ->setIban($responseBody['request_data']['iban'])
            ->setBankName($responseBody['request_data']['bank_name'])
            ->setOrderDescription($responseBody['request_data']['order_description'])
            ->setDateOfSignature(DateTime::createFromFormat('d.m.Y', $responseBody['request_data']['date_of_signature']))
            ->setMandateId($responseBody['request_data']['mandate_id'])
            ->setTransactionId($responseBody['request_data']['transaction_id']);

        $responseData = new ResponseData();
        $responseData
            ->setMid($responseBody['response_data']['mid'])
            ->setPaymentId($responseBody['response_data']['PayID'])
            ->setXid($responseBody['response_data']['XID'])
            ->setTransactionId($responseBody['response_data']['TransID'])
            ->setIban($responseBody['response_data']['IBAN'])
            ->setAccountOwner($responseBody['response_data']['AccOwner'])
            ->setBankName($responseBody['response_data']['AccBank'])
            ->setMandateId($responseBody['response_data']['mandateid'])
            ->setDateOfSignature(DateTime::createFromFormat('d.m.Y', $responseBody['response_data']['dtofsgntr']))
            ->setMandateSequenceType($responseBody['response_data']['mdtseqtype'])
            ->setStatus($responseBody['response_data']['Status'])
            ->setCode($responseBody['response_data']['Code'])
            ->setDescription($responseBody['response_data']['Description']);

        $response
            ->setStatus($responseBody['status'])
            ->setStatusCode($responseBody['statusCode'])
            ->setMessage($responseBody['message'])
            ->setRequestData($requestData)
            ->setResponseData($responseData);

        return $response;
    }
}
