<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model;

use DateTimeInterface;

/**
 * Class Flight
 * @package Vtours\Model
 */
class Flight
{
    /**
     * @var string
     */
    private $airline;

    /**
     * @var string
     */
    private $flightNumber;

    /**
     * @var int
     */
    private $segmentNumber;

    /**
     * @var string
     */
    private $type;

    /**
     * @var DateTimeInterface
     */
    private $depatureDateTime;

    /**
     * @var string
     */
    private $depatureCode;

    /**
     * @var DateTimeInterface
     */
    private $arrivalDateTime;

    /**
     * @var string
     */
    private $destinationCode;

    /**
     * @return string
     */
    public function getAirline()
    {
        return $this->airline;
    }

    /**
     * @param string $airline
     * @return Flight
     */
    public function setAirline($airline)
    {
        $this->airline = $airline;
        return $this;
    }

    /**
     * @return string
     */
    public function getFlightNumber()
    {
        return $this->flightNumber;
    }

    /**
     * @param string $flightNumber
     * @return Flight
     */
    public function setFlightNumber($flightNumber)
    {
        $this->flightNumber = $flightNumber;
        return $this;
    }

    /**
     * @return int
     */
    public function getSegmentNumber()
    {
        return $this->segmentNumber;
    }

    /**
     * @param int $segmentNumber
     * @return Flight
     */
    public function setSegmentNumber($segmentNumber)
    {
        $this->segmentNumber = $segmentNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param string $type
     * @return Flight
     */
    public function setType($type)
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return DateTimeInterface
     */
    public function getDepatureDateTime()
    {
        return $this->depatureDateTime;
    }

    /**
     * @param DateTimeInterface $depatureDateTime
     * @return Flight
     */
    public function setDepatureDateTime($depatureDateTime)
    {
        $this->depatureDateTime = $depatureDateTime;
        return $this;
    }

    /**
     * @return string
     */
    public function getDepatureCode()
    {
        return $this->depatureCode;
    }

    /**
     * @param string $depatureCode
     * @return Flight
     */
    public function setDepatureCode($depatureCode)
    {
        $this->depatureCode = $depatureCode;
        return $this;
    }

    /**
     * @return DateTimeInterface
     */
    public function getArrivalDateTime()
    {
        return $this->arrivalDateTime;
    }

    /**
     * @param DateTimeInterface $arrivalDateTime
     * @return Flight
     */
    public function setArrivalDateTime($arrivalDateTime)
    {
        $this->arrivalDateTime = $arrivalDateTime;
        return $this;
    }

    /**
     * @return string
     */
    public function getDestinationCode()
    {
        return $this->destinationCode;
    }

    /**
     * @param string $destinationCode
     * @return Flight
     */
    public function setDestinationCode($destinationCode)
    {
        $this->destinationCode = $destinationCode;
        return $this;
    }
}
