<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model;

use JMS\Serializer\Annotation\Type;

/**
 * Class FlightGroup
 * @package Vtours\Model
 */
class FlightGroup
{
    /**
     * @Type("array<Vtours\Model\Flight>")
     * @var Flight[]
     */
    private $flights;

    /**
     * @return Flight[]
     */
    public function getFlights()
    {
        return $this->flights;
    }

    /**
     * @param Flight[] $flights
     * @return FlightGroup
     */
    public function setFlights($flights)
    {
        $this->flights = $flights;
        return $this;
    }
}
