<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Message;

use JMS\Serializer\Annotation as Serializer;
use Vtours\Model\AbstractMessage;
use Vtours\Model\FlightGroup;

/**
 * Class FlightGroupMessage
 * @package Vtours\Message
 */
class FlightGroupMessage extends AbstractMessage
{
    const EVENT_CREATE = "create";
    const EVENT_UPDATE = "update";

    /**
     * @Serializer\Type("Vtours\Model\FlightGroup")
     *
     * @var FlightGroup
     */
    private $content;

    /**
     * @return FlightGroup|NULL
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * @param FlightGroup $content
     */
    public function setContent($content)
    {
        $this->content = $content;
    }
}
