<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model;

use JMS\Serializer\Annotation as JMS;

/**
 * Class FlightGroup
 * @package Vtours\Model
 */
class FlightGroup
{
    /**
     * @JMS\Type("int")
     */
    private $bookingId;

    /**
     * @JMS\Type("string")
     */
    private $client;

    /**
     * @JMS\Type("array<Vtours\Model\Flight>")
     */
    private $flights;

    /**
     * @JMS\Type("string")
     */
    private $provider;

    /**
     * @return int|null
     */
    public function getBookingId()
    {
        return $this->bookingId;
    }

    /**
     * @param int|null $bookingId
     * @return FlightGroup
     */
    public function setBookingId($bookingId)
    {
        $this->bookingId = $bookingId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getClient()
    {
        return $this->client;
    }

    /**
     * @param string $client
     * @return FlightGroup
     */
    public function setClient($client)
    {
        $this->client = $client;
        return $this;
    }

    /**
     * @return Flight[]
     */
    public function getFlights()
    {
        return $this->flights ? $this->flights : array();
    }

    /**
     * @param Flight[] $flights
     * @return FlightGroup
     */
    public function setFlights($flights)
    {
        $this->flights = $flights;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getProvider()
    {
        return $this->provider;
    }

    /**
     * @param string $provider
     * @return FlightGroup
     */
    public function setProvider($provider)
    {
        $this->provider = $provider;
        return $this;
    }
}
