<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Airport
 * @package Vtours\Model
 */
class Airport
{
    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $code;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $name;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $country;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $location;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $flightRoute;

    /**
     * @return string
     */
    public function getCode(): ?string
    {
        return $this->code;
    }

    /**
     * @param string $code
     * @return Airport
     */
    public function setCode(?string $code): Airport
    {
        $this->code = $code;
        return $this;
    }

    /**
     * @return string
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return Airport
     */
    public function setName(?string $name): Airport
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getCountry(): ?string
    {
        return $this->country;
    }

    /**
     * @param string $country
     * @return Airport
     */
    public function setCountry(?string $country): Airport
    {
        $this->country = $country;
        return $this;
    }

    /**
     * @return string
     */
    public function getLocation(): ?string
    {
        return $this->location;
    }

    /**
     * @param string $location
     * @return Airport
     */
    public function setLocation(?string $location): Airport
    {
        $this->location = $location;
        return $this;
    }

    /**
     * @return string
     * @see FlightRoute
     */
    public function getFlightRoute(): ?string
    {
        return $this->flightRoute;
    }

    /**
     * @param string $flightRoute
     * @return Airport
     * @see FlightRoute
     */
    public function setFlightRoute(?string $flightRoute): Airport
    {
        $this->flightRoute = $flightRoute;
        return $this;
    }
}
