<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model;

use DateTimeInterface;
use JMS\Serializer\Annotation as JMS;

/**
 * Class Flight
 * @package Vtours\Model
 */
class Flight
{
    /**
     * @JMS\Type("string")
     */
    private $airline;

    /**
     * @JMS\Type("string")
     */
    private $flightNumber;

    /**
     * @JMS\Type("int")
     */
    private $segmentNumber;

    /**
     * @JMS\Type("string")
     */
    private $type;

    /**
     * @JMS\Type("DateTime<'Y-m-d\TH:i:sP'>")
     */
    private $departureDateTime;

    /**
     * @JMS\Type("string")
     */
    private $departureCode;

    /**
     * @JMS\Type("DateTime<'Y-m-d\TH:i:sP'>")
     */
    private $arrivalDateTime;

    /**
     * @JMS\Type("string")
     */
    private $destinationCode;

    /**
     * @return string|null
     */
    public function getAirline()
    {
        return $this->airline;
    }

    /**
     * @param string $airline
     * @return Flight
     */
    public function setAirline($airline)
    {
        $this->airline = $airline;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->flightNumber;
    }

    /**
     * @param string $flightNumber
     * @return Flight
     */
    public function setFlightNumber($flightNumber)
    {
        $this->flightNumber = $flightNumber;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getSegmentNumber()
    {
        return $this->segmentNumber;
    }

    /**
     * @param int $segmentNumber
     * @return Flight
     */
    public function setSegmentNumber($segmentNumber)
    {
        $this->segmentNumber = $segmentNumber;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param string $type
     * @return Flight
     */
    public function setType($type)
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return DateTimeInterface|null
     */
    public function getDepartureDateTime()
    {
        return $this->departureDateTime;
    }

    /**
     * @param DateTimeInterface $departureDateTime
     * @return Flight
     */
    public function setDepartureDateTime($departureDateTime)
    {
        $this->departureDateTime = $departureDateTime;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDepartureCode()
    {
        return $this->departureCode;
    }

    /**
     * @param string $departureCode
     * @return Flight
     */
    public function setDepartureCode($departureCode)
    {
        $this->departureCode = $departureCode;
        return $this;
    }

    /**
     * @return DateTimeInterface|null
     */
    public function getArrivalDateTime()
    {
        return $this->arrivalDateTime;
    }

    /**
     * @param DateTimeInterface $arrivalDateTime
     * @return Flight
     */
    public function setArrivalDateTime($arrivalDateTime)
    {
        $this->arrivalDateTime = $arrivalDateTime;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDestinationCode()
    {
        return $this->destinationCode;
    }

    /**
     * @param string $destinationCode
     * @return Flight
     */
    public function setDestinationCode($destinationCode)
    {
        $this->destinationCode = $destinationCode;
        return $this;
    }
}
