<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Hotel\Payment\Calculation;

/**
 * Class CalculationTrait
 * @package Vtours\Model\Hotel\Payment\Calculation
 */
trait CalculationTrait
{
    /**
     * @var double
     */
    private $conversionRate;

    /**
     * @var string
     */
    private $bookedCurrency;

    /**
     * @var \DateTime
     */
    private $date;

    /**
     * @var double
     */
    private $price;

    /**
     * @var double
     */
    private $currentPrice;

    /**
     * @var double
     */
    private $totalPrice;

    /**
     * @return float
     */
    public function getConversionRate()
    {
        return $this->conversionRate;
    }

    /**
     * @param float $conversionRate
     * @return CalculationTrait
     */
    public function setConversionRate($conversionRate)
    {
        $this->conversionRate = $conversionRate;
        return $this;
    }

    /**
     * @return string
     */
    public function getBookedCurrency()
    {
        return $this->bookedCurrency;
    }

    /**
     * @param string $bookedCurrency
     * @return CalculationTrait
     */
    public function setBookedCurrency($bookedCurrency)
    {
        $this->bookedCurrency = $bookedCurrency;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @param \DateTime $date
     * @return CalculationTrait
     */
    public function setDate($date)
    {
        $this->date = $date;
        return $this;
    }

    /**
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * @param float $price
     * @return CalculationTrait
     */
    public function setPrice($price)
    {
        $this->price = $price;
        return $this;
    }

    /**
     * @return float
     */
    public function getCurrentPrice()
    {
        return $this->currentPrice;
    }

    /**
     * @param float $currentPrice
     * @return CalculationTrait
     */
    public function setCurrentPrice($currentPrice)
    {
        $this->currentPrice = $currentPrice;
        return $this;
    }

    /**
     * @return float
     */
    public function getTotalPrice()
    {
        return $this->totalPrice;
    }

    /**
     * @param float $totalPrice
     * @return CalculationTrait
     */
    public function setTotalPrice($totalPrice)
    {
        $this->totalPrice = $totalPrice;
        return $this;
    }
}
