<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Hotel\Payment\Cancellation;

use Vtours\Model\Hotel\Payment\Invoice\Invoice;

/**
 * Class CancellationTrait
 * @package Vtours\Model\Hotel\Payment\Cancellation
 */
trait CancellationTrait
{
    /**
     * @var double
     */
    private $price;

    /**
     * @var double
     */
    private $currentPrice;

    /**
     * @var string
     */
    private $currency;

    /**
     * @var Invoice
     */
    private $invoice;

    /**
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * @param float $price
     * @return CancellationTrait
     */
    public function setPrice($price)
    {
        $this->price = $price;
        return $this;
    }

    /**
     * @return float
     */
    public function getCurrentPrice()
    {
        return $this->currentPrice;
    }

    /**
     * @param float $currentPrice
     * @return CancellationTrait
     */
    public function setCurrentPrice($currentPrice)
    {
        $this->currentPrice = $currentPrice;
        return $this;
    }

    /**
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param string $currency
     * @return CancellationTrait
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;
        return $this;
    }

    /**
     * @return Invoice
     */
    public function getInvoice()
    {
        return $this->invoice;
    }

    /**
     * @param Invoice $invoice
     * @return CancellationTrait
     */
    public function setInvoice($invoice)
    {
        $this->invoice = $invoice;
        return $this;
    }
}
