<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Hotel\Payment\EarlyBooking;

use Vtours\Model\Hotel\Payment\Invoice\InvoiceTrait;

/**
 * Trait EarlyBookingTrait
 * @package Vtours\Model\Hotel\Payment\EarlyBooking
 */
trait EarlyBookingTrait
{
    use InvoiceTrait;

    /**
     * @var boolean
     */
    private $discount;

    /**
     * @return bool
     */
    public function isDiscount()
    {
        return $this->discount;
    }

    /**
     * @param bool $discount
     * @return EarlyBookingTrait
     */
    public function setDiscount($discount)
    {
        $this->discount = $discount;
        return $this;
    }

}
