<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Hotel\Payment;

use Vtours\Model\Hotel\Payment\Calculation\Calculation;
use Vtours\Model\Hotel\Payment\Cancellation\Cancellation;
use Vtours\Model\Hotel\Payment\EarlyBooking\EarlyBooking;
use Vtours\Model\Hotel\Payment\Invoice\Invoice;
use Vtours\Model\Hotel\PriceHistory\PriceHistory;

/**
 * Trait PaymentTrait
 * @package Vtours\Model\Hotel\Payment
 */
trait PaymentTrait
{
    /**
     * @var integer
     */
    private $creditorAccount;

    /**
     * @var Invoice
     */
    private $invoice;

    /**
     * @var double
     */
    private $minimumRegulation;

    /**
     * @var double
     */
    private $peakworkMargin;

    /**
     * @var EarlyBooking
     */
    private $earlyBooking;

    /**
     * @var Calculation
     */
    private $calculation;

    /**
     * @var Cancellation
     */
    private $cancellation;

    /**
     * @var PriceHistory[]
     */
    private $priceHistory;

    /**
     * @return int
     */
    public function getCreditorAccount()
    {
        return $this->creditorAccount;
    }

    /**
     * @param int $creditorAccount
     * @return PaymentTrait
     */
    public function setCreditorAccount($creditorAccount)
    {
        $this->creditorAccount = $creditorAccount;
        return $this;
    }

    /**
     * @return Invoice
     */
    public function getInvoice()
    {
        return $this->invoice;
    }

    /**
     * @param Invoice $invoice
     * @return PaymentTrait
     */
    public function setInvoice($invoice)
    {
        $this->invoice = $invoice;
        return $this;
    }

    /**
     * @return float
     */
    public function getMinimumRegulation()
    {
        return $this->minimumRegulation;
    }

    /**
     * @param float $minimumRegulation
     * @return PaymentTrait
     */
    public function setMinimumRegulation($minimumRegulation)
    {
        $this->minimumRegulation = $minimumRegulation;
        return $this;
    }

    /**
     * @return float
     */
    public function getPeakworkMargin()
    {
        return $this->peakworkMargin;
    }

    /**
     * @param float $peakworkMargin
     * @return PaymentTrait
     */
    public function setPeakworkMargin($peakworkMargin)
    {
        $this->peakworkMargin = $peakworkMargin;
        return $this;
    }

    /**
     * @return EarlyBooking
     */
    public function getEarlyBooking()
    {
        return $this->earlyBooking;
    }

    /**
     * @param EarlyBooking $earlyBooking
     * @return PaymentTrait
     */
    public function setEarlyBooking($earlyBooking)
    {
        $this->earlyBooking = $earlyBooking;
        return $this;
    }

    /**
     * @return Calculation
     */
    public function getCalculation()
    {
        return $this->calculation;
    }

    /**
     * @param Calculation $calculation
     * @return PaymentTrait
     */
    public function setCalculation($calculation)
    {
        $this->calculation = $calculation;
        return $this;
    }

    /**
     * @return Cancellation
     */
    public function getCancellation()
    {
        return $this->cancellation;
    }

    /**
     * @param Cancellation $cancellation
     * @return PaymentTrait
     */
    public function setCancellation($cancellation)
    {
        $this->cancellation = $cancellation;
        return $this;
    }

    /**
     * @return PriceHistory[]
     */
    public function getPriceHistory()
    {
        return $this->priceHistory;
    }

    /**
     * @param PriceHistory $priceHistory
     * @return PaymentTrait
     */
    public function addPriceHistory($priceHistory)
    {
        $this->priceHistory[] = $priceHistory;
        return $this;
    }

}
