<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Hotel\PriceHistory;

/**
 * Trait PriceHistoryTrait
 * @package Vtours\Model\Booking\PriceHistory
 */
trait PriceHistoryTrait
{
    /**
     * @var double
     */
    private $priceBefore;

    /**
     * @var double
     */
    private $priceAfter;

    /**
     * @var string
     */
    private $changedBy;

    /**
     * @var \DateTime
     */
    private $changedDate;

    /**
     * @return float
     */
    public function getPriceBefore()
    {
        return $this->priceBefore;
    }

    /**
     * @param float $priceBefore
     * @return PriceHistoryTrait
     */
    public function setPriceBefore($priceBefore)
    {
        $this->priceBefore = $priceBefore;
        return $this;
    }

    /**
     * @return float
     */
    public function getPriceAfter()
    {
        return $this->priceAfter;
    }

    /**
     * @param float $priceAfter
     * @return PriceHistoryTrait
     */
    public function setPriceAfter($priceAfter)
    {
        $this->priceAfter = $priceAfter;
        return $this;
    }

    /**
     * @return string
     */
    public function getChangedBy()
    {
        return $this->changedBy;
    }

    /**
     * @param string $changedBy
     * @return PriceHistoryTrait
     */
    public function setChangedBy($changedBy)
    {
        $this->changedBy = $changedBy;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getChangedDate()
    {
        return $this->changedDate;
    }

    /**
     * @param \DateTime $changedDate
     * @return PriceHistoryTrait
     */
    public function setChangedDate($changedDate)
    {
        $this->changedDate = $changedDate;
        return $this;
    }

}
