<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Hotel\BaseData;

use Vtours\Model\Hotel\Agent\Agent;
use Vtours\Model\Hotel\Location\Location;
use Vtours\Model\Hotel\Payment\Payment;

/**
 * Trait BaseData
 * @package Vtours\Model\Hotel\BaseData
 */
trait BaseDataTrait
{
    /**
     * @var integer
     */
    private $id;

    /**
     * @var integer
     */
    private $sequence;

    /**
     * @var string
     */
    private $code;

    /**
     * @var string
     */
    private $name;

    /**
     * @var \DateTime
     */
    private $departureDate;

    /**
     * @var \DateTime
     */
    private $arrivalDate;

    /**
     * @var \DateTime
     */
    private $dueDate;

    /**
     * @var \DateTime
     */
    private $lastUpdate;

    /**
     * @var string
     */
    private $hotelRating;

    /**
     * @var Agent
     */
    private $includedAgent;

    /**
     * @var Agent
     */
    private $transferAgent;

    /**
     * @var Payment
     */
    private $payment;

    /**
     * @var string
     */
    private $crsOfHotel;

    /**
     * @var string
     */
    private $travelerCount;

    /**
     * @var string
     */
    private $serviceProvider;

    /**
     * @var string
     */
    private $transferType;

    /**
     * @var Location
     */
    private $destination;

    /**
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param integer $id
     * @return BaseDataTrait
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return integer
     */
    public function getSequence()
    {
        return $this->sequence;
    }

    /**
     * @param integer $sequence
     * @return BaseDataTrait
     */
    public function setSequence($sequence)
    {
        $this->sequence = $sequence;
        return $this;
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param string $code
     * @return BaseDataTrait
     */
    public function setCode($code)
    {
        $this->code = $code;
        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return BaseDataTrait
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDepartureDate()
    {
        return $this->departureDate;
    }

    /**
     * @param \DateTime $departureDate
     * @return BaseDataTrait
     */
    public function setDepartureDate($departureDate)
    {
        $this->departureDate = $departureDate;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getArrivalDate()
    {
        return $this->arrivalDate;
    }

    /**
     * @param \DateTime $arrivalDate
     * @return BaseDataTrait
     */
    public function setArrivalDate($arrivalDate)
    {
        $this->arrivalDate = $arrivalDate;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }

    /**
     * @param \DateTime $dueDate
     * @return BaseDataTrait
     */
    public function setDueDate($dueDate)
    {
        $this->dueDate = $dueDate;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastUpdate()
    {
        return $this->lastUpdate;
    }

    /**
     * @param \DateTime $lastUpdate
     * @return BaseDataTrait
     */
    public function setLastUpdate($lastUpdate)
    {
        $this->lastUpdate = $lastUpdate;
        return $this;
    }

    /**
     * @return string
     */
    public function getHotelRating()
    {
        return $this->hotelRating;
    }

    /**
     * @param string $hotelRating
     * @return BaseDataTrait
     */
    public function setHotelRating($hotelRating)
    {
        $this->hotelRating = $hotelRating;
        return $this;
    }

    /**
     * @return Agent
     */
    public function getIncludedAgent()
    {
        return $this->includedAgent;
    }

    /**
     * @param Agent $includedAgent
     * @return BaseDataTrait
     */
    public function setIncludedAgent($includedAgent)
    {
        $this->includedAgent = $includedAgent;
        return $this;
    }

    /**
     * @return Agent
     */
    public function getTransferAgent()
    {
        return $this->transferAgent;
    }

    /**
     * @param Agent $transferAgent
     * @return BaseDataTrait
     */
    public function setTransferAgent($transferAgent)
    {
        $this->transferAgent = $transferAgent;
        return $this;
    }

    /**
     * @return Payment
     */
    public function getPayment()
    {
        return $this->payment;
    }

    /**
     * @param Payment $payment
     * @return BaseDataTrait
     */
    public function setPayment($payment)
    {
        $this->payment = $payment;
        return $this;
    }

    /**
     * @return string
     */
    public function getCrsOfHotel()
    {
        return $this->crsOfHotel;
    }

    /**
     * @param string $crsOfHotel
     * @return BaseDataTrait
     */
    public function setCrsOfHotel($crsOfHotel)
    {
        $this->crsOfHotel = $crsOfHotel;
        return $this;
    }

    /**
     * @return string
     */
    public function getTravelerCount()
    {
        return $this->travelerCount;
    }

    /**
     * @param string $travelerCount
     * @return BaseDataTrait
     */
    public function setTravelerCount($travelerCount)
    {
        $this->travelerCount = $travelerCount;
        return $this;
    }

    /**
     * @return string
     */
    public function getServiceProvider()
    {
        return $this->serviceProvider;
    }

    /**
     * @param string $serviceProvider
     * @return BaseDataTrait
     */
    public function setServiceProvider($serviceProvider)
    {
        $this->serviceProvider = $serviceProvider;
        return $this;
    }

    /**
     * @return string
     */
    public function getTransferType()
    {
        return $this->transferType;
    }

    /**
     * @param string $transferType
     * @return BaseDataTrait
     */
    public function setTransferType($transferType)
    {
        $this->transferType = $transferType;
        return $this;
    }

    /**
     * @return Location
     */
    public function getDestination()
    {
        return $this->destination;
    }

    /**
     * @param Location $destination
     * @return BaseDataTrait
     */
    public function setDestination($destination)
    {
        $this->destination = $destination;
        return $this;
    }
}
