<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Hotel\BaseData\BookingNumbers;

/**
 * Trait BookingNumbersTrait
 * @package Vtours\Model\Hotel\BaseData\BookingNumbers
 */
trait BookingNumbersTrait
{
    /**
     * @var integer
     */
    private $bookingId;

    /**
     * @var integer
     */
    private $serviceProvider;

    /**
     * @var integer
     */
    private $hotel;

    /**
     * @var integer
     */
    private $processNumberHotel;

    /**
     * @return int
     */
    public function getBookingId()
    {
        return $this->bookingId;
    }

    /**
     * @param int $bookingId
     * @return BookingNumbersTrait
     */
    public function setBookingId($bookingId)
    {
        $this->bookingId = $bookingId;
        return $this;
    }

    /**
     * @return integer
     */
    public function getServiceProvider()
    {
        return $this->serviceProvider;
    }

    /**
     * @param integer $serviceProvider
     * @return BookingNumbersTrait
     */
    public function setServiceProvider($serviceProvider)
    {
        $this->serviceProvider = $serviceProvider;
        return $this;
    }

    /**
     * @return integer
     */
    public function getHotel()
    {
        return $this->hotel;
    }

    /**
     * @param integer $hotel
     * @return BookingNumbersTrait
     */
    public function setHotel($hotel)
    {
        $this->hotel = $hotel;
        return $this;
    }

    /**
     * @return integer
     */
    public function getProcessNumberHotel()
    {
        return $this->processNumberHotel;
    }

    /**
     * @param integer $processNumberHotel
     * @return BookingNumbersTrait
     */
    public function setProcessNumberHotel($processNumberHotel)
    {
        $this->processNumberHotel = $processNumberHotel;
        return $this;
    }

}
