<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Hotel\Room;

/**
 * Trait RoomTrait
 * @package Vtours\Model\Hotel\Room
 */
trait RoomTrait
{
    /**
     * @var string
     */
    private $code;

    /**
     * @var string
     */
    private $crsCode;

    /**
     * @var string
     */
    private $typeGerman;

    /**
     * @var string
     */
    private $typeEnglish;

    /**
     * @var string
     */
    private $view;

    /**
     * @var string
     */
    private $mealType;

    /**
     * @var string
     */
    private $accommodation;

    /**
     * @var string
     */
    private $crsAccommodationGerman;

    /**
     * @var string
     */
    private $crsAccommodationEnglish;

    /**
     * @var boolean
     */
    private $singleRoom;

    /**
     * @var string
     */
    private $roomDescription;

    /**
     * @var string
     */
    private $roomBookingInfo;

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param string $code
     * @return RoomTrait
     */
    public function setCode($code)
    {
        $this->code = $code;
        return $this;
    }

    /**
     * @return string
     */
    public function getCrsCode()
    {
        return $this->crsCode;
    }

    /**
     * @param string $crsCode
     * @return RoomTrait
     */
    public function setCrsCode($crsCode)
    {
        $this->crsCode = $crsCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getTypeGerman()
    {
        return $this->typeGerman;
    }

    /**
     * @param string $typeGerman
     * @return RoomTrait
     */
    public function setTypeGerman($typeGerman)
    {
        $this->typeGerman = $typeGerman;
        return $this;
    }

    /**
     * @return string
     */
    public function getTypeEnglish()
    {
        return $this->typeEnglish;
    }

    /**
     * @param string $typeEnglish
     * @return RoomTrait
     */
    public function setTypeEnglish($typeEnglish)
    {
        $this->typeEnglish = $typeEnglish;
        return $this;
    }

    /**
     * @return string
     */
    public function getView()
    {
        return $this->view;
    }

    /**
     * @param string $view
     * @return RoomTrait
     */
    public function setView($view)
    {
        $this->view = $view;
        return $this;
    }

    /**
     * @return string
     */
    public function getMealType()
    {
        return $this->mealType;
    }

    /**
     * @param string $mealType
     * @return RoomTrait
     */
    public function setMealType($mealType)
    {
        $this->mealType = $mealType;
        return $this;
    }

    /**
     * @return string
     */
    public function getAccommodation()
    {
        return $this->accommodation;
    }

    /**
     * @param string $accommodation
     * @return RoomTrait
     */
    public function setAccommodation($accommodation)
    {
        $this->accommodation = $accommodation;
        return $this;
    }

    /**
     * @return string
     */
    public function getCrsAccommodationGerman()
    {
        return $this->crsAccommodationGerman;
    }

    /**
     * @param string $crsAccommodationGerman
     * @return RoomTrait
     */
    public function setCrsAccommodationGerman($crsAccommodationGerman)
    {
        $this->crsAccommodationGerman = $crsAccommodationGerman;
        return $this;
    }

    /**
     * @return string
     */
    public function getCrsAccommodationEnglish()
    {
        return $this->crsAccommodationEnglish;
    }

    /**
     * @param string $crsAccommodationEnglish
     * @return RoomTrait
     */
    public function setCrsAccommodationEnglish($crsAccommodationEnglish)
    {
        $this->crsAccommodationEnglish = $crsAccommodationEnglish;
        return $this;
    }

    /**
     * @return bool
     */
    public function isSingleRoom()
    {
        return $this->singleRoom;
    }

    /**
     * @param bool $singleRoom
     * @return RoomTrait
     */
    public function setSingleRoom($singleRoom)
    {
        $this->singleRoom = $singleRoom;
        return $this;
    }

    /**
     * @return string
     */
    public function getRoomDescription()
    {
        return $this->roomDescription;
    }

    /**
     * @param string $roomDescription
     * @return RoomTrait
     */
    public function setRoomDescription($roomDescription)
    {
        $this->roomDescription = $roomDescription;
        return $this;
    }

    /**
     * @return string
     */
    public function getRoomBookingInfo()
    {
        return $this->roomBookingInfo;
    }

    /**
     * @param string $roomBookingInfo
     * @return RoomTrait
     */
    public function setRoomBookingInfo($roomBookingInfo)
    {
        $this->roomBookingInfo = $roomBookingInfo;
        return $this;
    }
}
