# Message Model

## Description
This model is used to send good quality messages between applications using a message queueing technology such as "RabbitMQ".


## Installation

First you probably need to add this repository manually to the composer file so you can require it.

        "repositories": [
            {
                "type": "vcs",
                "url": "ssh://git@stash.life-style.de:7999/vcp/message-model.git"
            }
        ],

Now run following command to require this package.

    composer require vtours/messsage-model

## Usage
If you create a new data model package, use PHP 5.6 syntax and extend from the AbstractMessage class like in the following example:
```php
<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Message;

use JMS\Serializer\Annotation as Serializer;
use Vtours\Model\AbstractMessage;
use Vtours\Model\Car;

/**
 * Class CarMessage
 * @package Vtours\Message
 */
class CarMessage extends AbstractMessage
{
    const EVENT_CREATE = "create";
    const EVENT_UPDATE = "update";
    const EVENT_DELETE = "delete";

    /**
     * @Serializer\Type("Vtours\Model\Car")
     *
     * @var Car
     */
    private $content;

    /**
     * @return Car
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * @param Car $content
     */
    public function setContent($content)
    {
        $this->content = $content;
    }
}

``` 
1. The namespace should be _Vtours\Message_ for all message classes.
2. Just add _extends AbstractMessage_ and implement the two methods _getContent()_ and _setContent($content)_.
3. Also, you must add a private property $content with a Serializer\Type Annotation, because the JMS Serializer must be able to deserialize the json later.
4. It is recommended to add some constants to your message class (e.g. _EVENT_CREATE_, _EVENT_UPDATE_) and use them as parameters instead of static strings.  
  
  
  
## Message Instantiation
```php
$car = new Car('blue');

// specify the event and inject the corresponding model object ($car)
$carMessage = new CarMessage(CarMessage::EVENT_CREATE, $car);

// Do something with your new message.
```  
