<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model;

use Vtours\Model\Exception\MessageCreationFailedException;

/**
 * Class Message
 * @package Vtours\Model
 */
abstract class AbstractMessage
{
    /**
     * @var string
     */
    private $uuid;

    /**
     * @var string
     */
    private $eventName;

    /**
     * @var \DateTime
     */
    private $created;

    /**
     * @param string $eventName - Choose one of the following constants: Message::EVENT_CREATE, Message::EVENT_UPDATE, Message::EVENT_DELETE
     * @param mixed $content - The actual Content of the message
     */
    public function __construct($eventName, $content)
    {
        try {
            $this->uuid = \Ramsey\Uuid\Uuid::uuid4()->toString();
        } catch (\Exception $exception) {
            throw new MessageCreationFailedException($exception->getMessage(), 0, $exception);
        }

        try {
            $this->created = new \DateTime();
        } catch (\Exception $exception) {
            throw new MessageCreationFailedException($exception->getMessage(), 0, $exception);
        }

        $this->eventName = $eventName;

        $this->setContent($content);
    }

    /**
     * @return string
     */
    public function getUuid()
    {
        return $this->uuid;
    }

    /**
     * @return string
     */
    public function getEventName()
    {
        return $this->eventName;
    }

    /**
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * @return mixed
     */
    abstract public function getContent();

    /**
     * @param mixed $content
     */
    abstract public function setContent($content);
}
