<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model;
require_once("../../../vendor/autoload.php");
/**
 * Class Agency
 * @package Vtours\Model
 */
class Message
{
    const EVENT_CREATE = "create";
    const EVENT_UPDATE = "update";
    const EVENT_DELETE = "delete";

    /**
     * @var string
     */
    private $uuid;

    /**
     * @var string
     */
    private $object;

    /**
     * @var string
     */
    private $event;

    /**
     * @var \DateTime
     */
    private $created;

    /**
     * @var string
     */
    private $content;

    /**
     * @param string $object - The name of the affected object
     * @param string $event - Choose one of the following constants: Message::EVENT_CREATE, Message::EVENT_UPDATE, Message::EVENT_DELETE
     * @param string $content - The actual Content of the message
     * @throws \Exception
     */
    public function __construct($object, $event, $content)
    {
        $this->uuid = \Ramsey\Uuid\Uuid::uuid4();
        $this->created = new \DateTime();

        $this->object = $object;
        $this->event = $event;
        $this->content = $content;
    }

    /**
     * @return string
     */
    public function getUuid()
    {
        return $this->uuid;
    }

    /**
     * @return string
     */
    public function getObject()
    {
        return $this->object;
    }

    /**
     * @return string
     */
    public function getEvent()
    {
        return $this->event;
    }

    /**
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }
}
