<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Tests;

use PHPUnit\Framework\TestCase;
use Ramsey\Uuid\Uuid;
use Vtours\Model\Message;


/**
 * Class MessageTest
 * @package Vtours\Model\Tests
 */
class MessageTest extends TestCase
{

    public function test_correct_message_creation()
    {
        $correctMessage = new Message(
            "agency",
            Message::EVENT_CREATE,
            "This is a test String."
        );

        $newDateTime = new \DateTime();
        $newDateTime->format("Y-m-d H:i");

        $actualDateTime = $correctMessage->getCreated();
        $actualDateTime->format("Y-m-d H:i");

        $this->assertInstanceOf(\Ramsey\Uuid\Uuid::class, $correctMessage->getUuid());
        $this->assertTrue(Uuid::isValid($correctMessage->getUuid()));
        $this->assertInstanceOf(\DateTimeInterface::class, $actualDateTime);
        $this->assertSame($newDateTime->getTimestamp(), $actualDateTime->getTimestamp());
    }
}
