<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg,Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ProtocolServiceSdkBundle\DependencyInjection;

use Exception;
use LifeStyle\ProtocolServiceSdk\Service\ProtocolService;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;

/**
 * Class LifeStyleProtocolServiceSdkExtension
 * @package LifeStyle\ProtocolServiceSdkBundle\DependencyInjection
 */
class LifeStyleProtocolServiceSdkExtension extends Extension
{
    /**
     * @inheritDoc
     * @throws Exception
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configurationInstance = new LifeStyleProtocolServiceSdkConfiguration();
        $configuration = $this->processConfiguration($configurationInstance, $configs);

        $path = dirname(__DIR__) . '/Resources/config';
        (new YamlFileLoader($container, new FileLocator($path)))
            ->load('services.yaml');

        $this->process($configuration, $container);
    }

    public function process(array $configuration, ContainerBuilder $container)
    {
        if (!$container->has(ProtocolService::class)) {
            return;
        }

        $definition = $container->findDefinition(ProtocolService::class);
        $definition->setArgument(1, $configuration['base_uri']);
    }
}
