<?php
/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ProtocolServiceSdk\Model;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ProtocolLineFinancial
 * @package App\Entity
 *
 * @Serializer\AccessType(type=JMS\Serializer\Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(policy=Serializer\ExclusionPolicy::ALL)
 */
class ProtocolLineFinancial extends ProtocolLine
{
    /**
     * @var integer
     *
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("booking_id")
     * @Serializer\Expose()
     */
    private $bookingId;

    /**
     * @var float
     *
     * @Serializer\Type("float")
     * @Serializer\SerializedName("deducted_amount")
     * @Serializer\Expose()
     */
    private $deductedAmount;

    /**
     * @var string
     *
     * @Serializer\Type("string")
     * @Serializer\SerializedName("payment_method")
     * @Serializer\Expose()
     */
    private $paymentMethod;

    /**
     * @var boolean
     *
     * @Serializer\Type("boolean")
     * @Serializer\SerializedName("test_run")
     * @Serializer\Expose()
     */
    private $testRun = false;

    /**
     * @return int
     */
    public function getBookingId(): int
    {
        return $this->bookingId;
    }

    /**
     * @param int $bookingId
     * @return ProtocolLineFinancial
     */
    public function setBookingId(int $bookingId): ProtocolLineFinancial
    {
        $this->bookingId = $bookingId;
        return $this;
    }

    /**
     * @return float
     */
    public function getDeductedAmount(): float
    {
        return $this->deductedAmount;
    }

    /**
     * @param float $deductedAmount
     * @return ProtocolLineFinancial
     */
    public function setDeductedAmount(float $deductedAmount): ProtocolLineFinancial
    {
        $this->deductedAmount = $deductedAmount;
        return $this;
    }

    /**
     * @return string
     */
    public function getPaymentMethod(): string
    {
        return $this->paymentMethod;
    }

    /**
     * @param string $paymentMethod
     * @return ProtocolLineFinancial
     */
    public function setPaymentMethod(string $paymentMethod): ProtocolLineFinancial
    {
        $this->paymentMethod = $paymentMethod;
        return $this;
    }

    /**
     * @return bool
     */
    public function isTestRun(): bool
    {
        return $this->testRun;
    }

    /**
     * @param bool $testRun
     * @return ProtocolLineFinancial
     */
    public function setTestRun(bool $testRun): ProtocolLineFinancial
    {
        $this->testRun = $testRun;
        return $this;
    }
}
