<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg,Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ProtocolServiceSdk\Exception;

use Exception;
use Psr\Http\Client\ClientExceptionInterface;

/**
 * Class ProtocolServiceSdkException
 * @package LifeStyle\ProtocolServiceSdk\Service
 */
class ProtocolServiceSdkException extends Exception
{
    /**
     * @param Exception $exception
     * @return ProtocolServiceSdkException
     */
    public static function fromOtherException(Exception $exception): ProtocolServiceSdkException
    {
        return new self("General application error: {$exception->getMessage()}", $exception->getCode(), $exception);
    }

    /**
     * @param ClientExceptionInterface $exception
     * @return ProtocolServiceSdkException
     */
    public static function fromGuzzleException(ClientExceptionInterface $exception): ProtocolServiceSdkException
    {
        return new self("HTTP Exception: {$exception->getMessage()}", $exception->getCode(), $exception);
    }

    /**
     * @return ProtocolServiceSdkException
     */
    public static function fromInvalidBaseUri(): ProtocolServiceSdkException
    {
        return new self("Invalid 'base_uri'! You can configure this in the yaml file.");
    }

    /**
     * @return ProtocolServiceSdkException
     */
    public static function fromInvalidOrderBy(): ProtocolServiceSdkException
    {
        return new self("Invalid 'orderBy' value! The key and value have to be of type 'string'!.");
    }

    /**
     * @param string $orderByDirection
     * @return ProtocolServiceSdkException
     */
    public static function fromInvalidOrderByDirection(string $orderByDirection): ProtocolServiceSdkException
    {
        return new ProtocolServiceSdkException("The order direction '{$orderByDirection}' does not exist.");
    }

    /**
     * @param string $orderByField
     * @return ProtocolServiceSdkException
     */
    public static function fromInvalidOrderByField(string $orderByField): ProtocolServiceSdkException
    {
        return new ProtocolServiceSdkException("The order field '{$orderByField}' does not exist.");
    }
}
