<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg,Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ProtocolServiceSdk\Model;

use DateTimeImmutable;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class ProtocolLine
 * @package LifeStyle\ProtocolServiceSdk\Model
 *
 * @Serializer\AccessType(type=JMS\Serializer\Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(policy=Serializer\ExclusionPolicy::ALL)
 * @Serializer\Discriminator(field="type", disabled=false, map={"default":"LifeStyle\ProtocolServiceSdk\Model\ProtocolLine", "financial":"LifeStyle\ProtocolServiceSdk\Model\ProtocolLineFinancial"})
 */
class ProtocolLine
{
    /**
     * @var integer|null
     *
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("id")
     * @Serializer\Expose()
     */
    private $id;

    /**
     * @var string
     *
     * @Serializer\Type("string")
     * @Serializer\SerializedName("status")
     * @Serializer\Expose()
     */
    private $status;

    /**
     * @var string
     *
     * @Serializer\Type("string")
     * @Serializer\SerializedName("message")
     * @Serializer\Expose()
     */
    private $message;

    /**
     * @var DateTimeImmutable|null
     *
     * @Serializer\Type("DateTimeImmutable")
     * @Serializer\SerializedName("create_date")
     * @Serializer\Expose()
     */
    private $createDate;

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return ProtocolLine
     */
    public function setId(?int $id): ProtocolLine
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return string
     */
    public function getStatus(): string
    {
        return $this->status;
    }

    /**
     * @param string $status
     * @return ProtocolLine
     */
    public function setStatus(string $status): ProtocolLine
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return string
     */
    public function getMessage(): string
    {
        return $this->message;
    }

    /**
     * @param string $message
     * @return ProtocolLine
     */
    public function setMessage(string $message): ProtocolLine
    {
        $this->message = $message;

        return $this;
    }

    /**
     * @return DateTimeImmutable|null
     */
    public function getCreateDate(): ?DateTimeImmutable
    {
        return $this->createDate;
    }

    /**
     * @param DateTimeImmutable|null $createDate
     * @return ProtocolLine
     */
    public function setCreateDate(?DateTimeImmutable $createDate): ProtocolLine
    {
        $this->createDate = $createDate;

        return $this;
    }
}
