<?php
/**
 * *
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 * /
 */

use AsyncPHP\Doorman\Manager\ProcessManager;
use AsyncPHP\Doorman\Task\ProcessCallbackTask;


class Manager extends Rula2Std
{

    const INSERT = 'insert';
    const UPDATE = 'update';
    const ERROR = 'error';

    protected $p_id;

    public static $instance = null;
    public $rpm_id;
    public $ini;
    /**
     * @var Booking_Repository_Manager
     */
    private $dataBaseRepository;

    /**
     * @var ProcessManager
     */
    private $manager;

    /**
     * @return Manager|Rula2Std|null
     */
    public static function getInstance()
    {

        if (self::$instance == null) {
            return new self();
        }

        return self();
    }

    /**
     * Manager constructor.
     */
    public function __construct()
    {
        parent::init();
        $this->dataBaseRepository = new Booking_Repository_Manager($this->db, $this->log);
        $this->manager = new ProcessManager();
    }

    public function init()
    {
        parent::init();
    }

    /**
     * @param SchedulerItem $obj
     * @return bool|mixed|void|null
     * @throws Exception
     */
    public function isProcessOrSchedulerRunning(SchedulerItem $obj)
    {
        $res = null;
        try {

            if (!is_object($obj)) {
                throw new Rulas2Exception('Kein Objekt breche Scheduler ab.');
            }

            if ($obj->rpm_error == 1) {
                return;
            }

            $res = $this->dataBaseRepository->isProcessStartedOrNotFinish($obj);
            $this->dataBaseRepository->getDataBaseError();

            if (!$res) {
                return false;
            }

        } catch (Exception $e) {
            throw new Rulas2Exception($e->getMessage());
        }

        return $res;
    }

    /**
     * @param SchedulerItem $obj
     * @throws Rulas2Exception
     */
    public function startProcess(SchedulerItem $obj)
    {
        try {
            if (!is_object($obj) || $obj->prm_id < 0) {
                throw new Rulas2Exception('no object or no id to start scheduler');
            }

            if (is_dir('/data1/www/')) {
                $shellAufrufParams = $this->ini->shell->un->toarray();
            } else {
                $shellAufrufParams = $this->ini->shell->win->toarray();
            }

            $execute = $shellAufrufParams['php'] . " "
                . $shellAufrufParams['cli'] . " "
                . $shellAufrufParams['arguments'] . " "
                . $obj->rpm_id;


            if ($this->ini->threads == 1) {
                $this->registerProcessForStart($execute);
            } else {
                system(
                    $execute . " > '" . $this->ini->logPfad . "/" . date('Ymd') . "_rula2" . ".log'"
                );
                $this->log->info('\t fuehre folgenden Befehl aus. Exec::' . $execute);
            }

        } catch (Exception $e) {
            throw new Rulas2Exception($e->getMessage());
        }
    }

    /**
     * @param SchedulerItem $obj
     * @param string $event
     * @param string $mode
     * @return int|null
     * @throws Exception
     */
    public function writeIntoManagerTable(SchedulerItem $obj, $event, $mode = self::INSERT)
    {

        $this->init();
        try {
            $rpm_id = null;

            $event = $obj->rpm_error ? self::ERROR : $event;

            if (($event == 'start' || $event == self::ERROR) && is_object($obj)) {
                $data = array();
                $data['rsc_id'] = $obj->rsc_id;
                $data['p_id'] = $obj->p_id;
                $data['rsci_start'] = $obj->rsci_start;
                $data['rsci_day'] = $obj->rsci_day;
                $data['rpm_active'] = ($event == 'start' ? 1 : 0);

                if ($event == self::ERROR) {
                    $data['rpm_error'] = 1;
                    $data['rpm_message'] = $obj->rpm_message;
                }

                $data['rpm_start'] = date('Y-m-d H:i:s');

                $this->insertOrUpdateManagerData($mode, $data, $obj);

                $this->dataBaseRepository->getDataBaseError();

                if ($mode == self::INSERT) {
                    $rpm_id = $this->dataBaseRepository->getLastManagerIdFromSequence();
                    $this->dataBaseRepository->getDataBaseError();
                } else {
                    $rpm_id = $obj->rpm_id;
                }

                $message = "Schreiben in die " . $this->table . " hat geklappt. Folgende ID ::" . $rpm_id;
                $this->log->info($message);

            } elseif ($event == 'finish') {
                $rpm_id = $obj->rpm_id;
                $this->dataBaseRepository->updateDataBaseFlagsForFinishProcess($obj);
                $this->log->info('Setzen auf Finish in Managment Tabelle erfolgreich. ID::' . $rpm_id);
            } else {
                $message = 'Kein Objekt im Start. Breche ab';
                throw new Rulas2Exception($message);
            }

        } catch (Exception $e) {
            throw new Rulas2Exception($e->getMessage());
        }
        return $rpm_id;
    }

    /**
     * @param $id
     * @return bool|ManagerItem
     * @throws Exception
     */
    public function getManagerDataFromTable($id)
    {

        try {

            if ($id <= 0 || $id == null || $id == '') {
                throw new Rulas2Exception('Keine ID um ManagerData zuholen');
            }

            $res = $this->dataBaseRepository->getManagerDataById($id);

            if ($res == null || count($res) <= 0 || $res == '') {
                $this->log->err('ManagerData Set not found' . $id);
                return false;
            }

            $item = $this->createManagerItem();

            foreach ($res[0] as $key => $value) {
                $item->$key = $value;
            }

            return $item;

        } catch (Exception $e) {
            throw new Rulas2Exception($e->getMessage());
        }
    }

    /**
     * @return ManagerItem
     */
    private function createManagerItem()
    {
        return new ManagerItem();
    }

    /**
     * @param string $mode
     * @param array $data
     * @param SchedulerItem $obj
     * @throws Rulas2Exception
     */
    public function insertOrUpdateManagerData($mode, $data, SchedulerItem $obj)
    {
        if (!$mode || !is_array($data) || count($data) <= 0 || !$obj) {
            throw new Rulas2Exception('no data to insert or update data ' . __METHOD__);
        }

        if ($mode == self::INSERT) {
            $this->dataBaseRepository->insertProcessToManagerTable($data);
        } elseif ($mode == self::UPDATE) {
            $this->dataBaseRepository->updateProcessManagerTable($data, $obj);
        }
    }

    /**
     * @return bool
     */
    public function startProcesses()
    {
        $res = false;
        if ($this->ini->threads == 1) {
            $res = $this->manager->tick();
        }
        return $res;
    }

    /**
     * @param string $execute
     */
    private function registerProcessForStart($execute)
    {
        $this->manager->addTask(
            new ProcessCallbackTask(
                function () use ($execute) {
                    exec($execute);
                }
            )
        );

        $this->log->info($execute . ' is registered for start.');
    }
}