<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
class Booking_Schalterinfo extends Rula2Std{
	
	
	private $table;
	private $rula_schalterinfo;
	private $rula_flughafen;
	private $rula_standort;
	private $rula_telefon;
	
	private $htmlText;
	private $text;
	
	public function __construct(){
		
		$this->table = "RULA_TICKETONDEMAND_INFO";
		parent::init();
	}
	
	public function __set($key,$value){
		if(is_numeric($key)){
			$temp = strtolower($key);
			$this->$temp = $value;
		}
	}
	
	public function __get($name){
		if(isset($this->$name))
			return $this->$name;
		else 
			return null;
	}
	
	public function getSchalterInfo($airline , $zielgebiet){
		
		try{
			if($airline == null || $airline == '' || $zielgebiet == null || $zielgebiet == '')
				return;
			
			$stmt = "SELECT * 
					 FROM $this->table 
					 WHERE lower(RULA_AIRLINE) = '".strtolower($airline)."'
					 AND lower(RULA_ZIELGEBIET) = '".strtolower($zielgebiet)."'";
			
			
			$res = $this->db->getAll($stmt);
			
			if($this->db->errorMsg()){
				echo $this->db->errorMsg();
				throw new Exception('Fehler in der DB Abfrage. MSG::'.$this->db->errorMsg());
				
			}

			if($res == '' || $res == null || count($res) <= 0){
				$this->log->info('Kein Schalterinfo vorhanden');
			}
			
			if(count($res[0]) <= 0) return ;
			
			foreach($res[0] as $key => $value){
				if(!is_numeric($key)){
					$temp = strtolower($key);
					$this->$temp = $value;
				}
			}
			
		}catch(Exception $e){
			throw new Exception('Fehler in der DB Abfrage um Schalterinfo zuholen');
		}
	
	}
	public function getHtml(){
		
		$this->htmlText = 
			$this->rula_schalterinfo."<br />"
			.$this->rula_flughafen."<br />"	
			.$this->rula_standort."<br />"
			.$this->rula_telefon."<br />";
		
		
		return $this->htmlText;
		
	}
	
	public function getText(){
		
		$this->text =  
			$this->rula_schalterinfo."\r\n"
			.$this->rula_flughafen."\r\n"	
			.$this->rula_standort."\r\n"
			.$this->rula_telefon."\r\n";
		
		return $this->text;
		
	}
	
	
}
?>
