<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class FileItem  {
	
	protected $dir;
	protected $fileName;
	protected $dirFile;
	protected $id;
	protected $isBookingFile = false;
	protected $isProcessFile = false;
	protected $isFlugFile = false;
	protected $returnValue = null;
	protected $mimetype = null;
	
	public function setFromArray($arr = array()) {
		if (!is_array($arr)) return;
		
		foreach ($arr as $key => $value) {
			if(!is_numeric($key)){
				$this->$key = $value;
			}
		}
	}
	
	public function __set($name, $value) {
		$this->$name = $value;
	}
	
	public function __get($name) {
		return $this->$name;
	}
	
	public function getDir(){
		return $this->dir;
	}
	
	public function getFileName(){
		return $this->fileName;		
	}
	
	public function getCompleteFileName(){
		return $this->dirFile;
	}
	
	public function getId(){
		return $this->id;
	}
	
	public function isBookingFile(){
		return $this->isBookingFile;
	}
	
	public function isProzessfile(){
		return $this->isProcessFile;
	}
	
	public function isFlugVoucherfile(){
		return $this->isFlugFile;
	}
	
	public function getFileTyp(){
		if(is_file($this->dirFile))
			return filetype($this->dirFile);
		else
			return false;
	}
	
	public function getContentOfFile(){
		
		if(is_file($this->dirFile)){
			return file_get_contents($this->dirFile);
		}
		else
			return false;
	}
	
	public function removeFileToProcessed(){
		
		try{
			$newDir = str_replace('new', 'processed', $this->dirFile);
			$stat = rename($this->dirFile, $newDir);
			
			if(!$stat)
				throw new Exception('Fehler beim verschieben. file::'.$this->dirFile);
			
		}catch(Exception $e){
			throw new Exception($e->getMessage());
		}
	}
	
}

?>
