<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

class Extendablemagic
{

    /**
     * @var array
     */
    protected $_Datastore = [];

    /**
     * @var array
     */
    protected $_convert_keys = [];

    /**
     * @var int[]
     */
    protected $not_convert_keys = [
        'ht_hotelname' => 1,
        'hta_city' => 1,
        'ht_roomtype' => 1,
        'ht_roomaccomodation' => 1,
        'ht_mealtype' => 1
    ];


    /**
     * Extendablemagic constructor.
     * @param array $arr
     */
    public function __construct($arr = array())
    {
        if (!is_array($arr)) {
            return;
        }

        foreach ($arr as $key => $value) {
            if (!is_numeric($key)) {
                $k = strtolower($key);
                $this->$k = $value;
            }
        }
    }

    /**
     * @param string $key
     * @param string|int|float|bool|null $val
     */
    public function __set($key, $val)
    {
        if (!is_numeric($key)) {
            $this->_Datastore[$key] = $val;
        }
    }

    /**
     * @param string $key
     * @return mixed|string
     */
    public function __get($key)
    {

        if (
            (
                (is_array($this->_convert_keys) && in_array($key, $this->_convert_keys)) ||
                (!is_array($this->_convert_keys) && $this->_convert_keys == 'all')
            ) && ($this->not_convert_keys[$key] != 1)
        ) {
            return mb_convert_case($this->_Datastore[$key], MB_CASE_TITLE, "UTF-8");
        }

        return $this->_Datastore[$key];
    }

    /**
     * @param mixed $var
     */
    public function __unset($var)
    {
        unset($this->_Datastore[$var]);
    }

    /**
     * @param string $var
     * @return bool
     */
    public function __isset($var)
    {
        return isset($this->_Datastore[$var]);
    }

    /**
     * @return array
     */
    public function getData()
    {
        $ret = array();

        foreach ($this->_Datastore as $k => $v) {
            $ret[$k] = $this->$k;
        }
        return $ret;
    }

    /**
     * @return object
     */
    public function getDataAsObject()
    {
        return (object)$this->_Datastore;
    }
}