<?php

class Rula2DocucenterData {

	private $db;
	 
	public $zielGebiet;
	public $hotelLocationCode;
	public $hotelCode;
	private $sort;

	public function __construct() {

		$this->db = DB::stepIn();
		$this->sort = array("VT_BO_ID", "TO_CHAR(VT_BO_BEGINN,'YYYY-MM-DD')", "HT_HOTELNAME", "VT_FLI_SV_TICKETTYPE");
	}

	public function getCountriesForSelection() {
		if (tgcSession::stepIn()->getVar('getAllCountries') == '') {
			$stmt = "SELECT DISTINCT(Land)
					 FROM VT_BOOKINGS,AIRPORT_CODES
					 WHERE VT_BO_DESTINATION IS NOT NULL
                     AND LC = VT_BO_DESTINATION
					 AND TO_CHAR(VT_BO_BEGINN,'YYYYMMDD') BETWEEN TO_CHAR(SYSDATE , 'YYYYMMDD') AND TO_CHAR(SYSDATE +21,'YYYYMMDD')
					 AND VT_BO_STORNO != 1
					 AND VT_BO_BOOKINGACTION != 'TB'
					 AND VT_BO_INTERNALTREATMENTCONDITI != 'TX' ORDER BY 1";


			$res = $this->db->getAll($stmt);
			tgcSession::stepIn()->setVar('getCountries', serialize($res));
		} else {
			$temp = tgcSession::stepIn()->getVar('getAllZg');

			$res = unserialize($temp);
		}

		return $res;
	}

	public function getCountrieForZg($zg){
		$stmt = "SELECT DISTINCT(Land) FROM AIRPORT_CODES WHERE LC = '".$zg."'";

		return $this->db->getOne($stmt);
	}

	public function getAllZg($land = "") {

		if (tgcSession::stepIn()->getVar('getAllZg'.$land) == '') {

			$stmt = "SELECT DISTINCT(VT_BO_DESTINATION)
					 FROM VT_BOOKINGS 
					 WHERE VT_BO_DESTINATION IS NOT NULL 
					 AND TO_CHAR(VT_BO_BEGINN,'YYYYMMDD') BETWEEN TO_CHAR(SYSDATE , 'YYYYMMDD') AND TO_CHAR(SYSDATE +21,'YYYYMMDD')
					 AND VT_BO_STORNO != 1
					 AND VT_BO_BOOKINGACTION != 'TB'";
			if ($land)
			$stmt .= "AND VT_BO_DESTINATION IN (SELECT LC FROM AIRPORT_CODES WHERE LAND = '" . $land . "')";
			else
			$stmt .= "AND VT_BO_INTERNALTREATMENTCONDITI != 'TX' ORDER BY 1";


			$res = $this->db->getAll($stmt);

			tgcSession::stepIn()->setVar('getAllZg'.$land, serialize($res));
		} else {

			$temp = tgcSession::stepIn()->getVar('getAllZg'.$land);

			$res = unserialize($temp);
		}

		return $res;
	}

	public function getHotelLocationForThisZg($zielGebiet) {

		if (tgcSession::stepIn()->getVar('getAllHotellocation_' . $zielGebiet) == '') {

			$stmt = "SELECT DISTINCT(HT_HOTELLOCCODE)
					FROM VT_HOTELS,VT_BOOKINGS
					WHERE TO_CHAR(VT_BO_BEGINN,'YYYYMMDD') BETWEEN TO_CHAR(SYSDATE , 'YYYYMMDD') AND TO_CHAR(SYSDATE +21,'YYYYMMDD')
					AND VT_BO_STORNO != 1
					AND VT_BO_BOOKINGACTION != 'TB'
					AND VT_BO_INTERNALTREATMENTCONDITI != 'TX'
					AND VT_BO_ID = HT_BO_ID
					AND HT_DESTAIRPORT = '$zielGebiet' 
					ORDER BY 1";

			$res = $this->db->getAll($stmt);

			tgcSession::stepIn()->setVar('getAllHotellocation_' . $zielGebiet, serialize($res));
		} else {

			$res = unserialize(tgcSession::stepIn()->getVar('getAllHotellocation_' . $zielGebiet));
		}

		return $res;
	}

	public function getHotelCodesForThisHotelLocation($zielGebiet, $hotelLocationCode) {

		if (tgcSession::stepIn()->getVar('getHotelCodes_' . $zielGebiet . "_" . $hotelLocationCode) == '') {

			$stmt = "SELECT DISTINCT(HT_HOTELCODE)
					 FROM VT_HOTELS,VT_BOOKINGS
					 WHERE TO_CHAR(VT_BO_BEGINN,'YYYYMMDD') BETWEEN TO_CHAR(SYSDATE , 'YYYYMMDD') AND TO_CHAR(SYSDATE +21,'YYYYMMDD')
					 AND VT_BO_STORNO != 1
					 AND VT_BO_BOOKINGACTION != 'TB'
					 AND VT_BO_INTERNALTREATMENTCONDITI != 'TX' 
					 AND HT_BO_ID = VT_BO_ID
					 AND HT_DESTAIRPORT = '$zielGebiet' 
					 AND HT_HOTELLOCCODE = '$hotelLocationCode' ORDER BY 1";

			$res = $this->db->getAll($stmt);



			tgcSession::stepIn()->setVar('getHotelCodes_' . $zielGebiet . "_" . $hotelLocationCode, serialize($res));
		} else {

			$res = unserialize(tgcSession::stepIn()->getVar('getHotelCodes_' . $zielGebiet . "_" . $hotelLocationCode));
		}


		return $res;
	}

	public function getIncominAgenciesForUpload() {

		if (!tgcSession::stepIn()->getVar(getIncomingAgencies)) {
			$stmt = "SELECT * FROM RULA_ZG_SPZ_ORDNER WHERE TYPE = 'INCAGENT'";

			$res = $this->db->getAll($stmt);

			tgcSession::stepIn()->setVar('getIncomingAgencies', serialize($res));
		} else {
			$res = unserialize(tgcSession::stepIn()->getVar('getIncomingAgencies'));
		}

		return $res;
	}

	public function getAllBookings($vt_bo_id = '') {

		$stmt = "
					SELECT 
						VT_BO_ID,
						SUBSTR(VT_BO_CUSTOMER_FIRSTNAME,0,1)||'. '||VT_BO_CUSTOMER_NAME as VT_BO_CUSTOMER_NAME,
						TO_CHAR(VT_BO_BEGINN,'YYYY-MM-DD'),
						TO_CHAR(VT_BO_BEGINN,'DD.MM.YYYY') as VT_BO_BEGINNANZ,
						TO_CHAR(VT_BO_BEGINN,'YYYY') as VT_BO_BEGINNYEAR,
						VT_FLI_SV_TICKETTYPE,
						VT_BO_BOOKINGTYPE,
						VT_BO_INTERNALTREATMENTCONDITI,
						TO_CHAR(VT_BO_CREATED,'DD.MM.YYYY') as VT_BO_CREATED,
						HT_HOTELNAME,
						VT_BO_DESTINATION,
						HT_HOTELCODE,
						HT_HOTELLOCCODE,
						HT_INCAGENT,
						HT_TRANSFERAGENT,
						VT_BO_BOOKINGTYPE
						
						FROM VT_BOOKINGS
						
						LEFT JOIN VT_HOTELS ON HT_BO_ID = VT_BO_ID AND HT_HOTEL_NO = 1
						LEFT JOIN VT_FLIGHT_SAVED ON VT_FLI_SV_ID = VT_BO_ID AND VT_FLI_SV_NUMBER = 1
						WHERE VT_BO_BOOKINGACTION != 'TB' 
						AND VT_BO_STORNO != 1
						AND VT_BO_TOTALPRICE > 0.01";
		if ($vt_bo_id == '') {
			$stmt .= " AND HT_DESTAIRPORT = '$this->zielGebiet'
						AND (VT_BO_INTERNALTREATMENTCONDITI != 'TX' OR VT_BO_INTERNALTREATMENTCONDITI IS NULL)
						AND TO_CHAR(VT_BO_BEGINN,'YYYYMMDD') BETWEEN TO_CHAR(SYSDATE , 'YYYYMMDD') AND TO_CHAR(SYSDATE +21,'YYYYMMDD')
						AND HT_HOTELLOCCODE = '$this->hotelLocationCode'
						AND HT_HOTELCODE = '$this->hotelCode'";
		} else if ($vt_bo_id > 0) {
			$stmt .= " AND VT_BO_ID = " . $vt_bo_id;
		}

		if (Context::stepIn()->getVar('sort') != '') {
			$stmt .= " ORDER BY " . $this->sort[Context::stepIn()->getVar('sort')];
			if (Context::stepIn()->getVar('direction') == 'down')
			$stmt .= " DESC";
			if (Context::stepIn()->getVar('direction') == 'up')
			$stmt .= " ASC";
		}
		$res = $this->db->getAll($stmt);

		foreach ($res as $value) {
			$item[$value['VT_BO_ID']] = new Rula2DocucenterItem($value);
		}
		tgcSession::stepIn()->setVar('actList', serialize($item));
		return $item;
	}

	public static function getDataOfOneBooking($vt_bo_id) {

		$item = unserialize(tgcSession::stepIn()->getVar('actList'));
		return $item[$vt_bo_id];
	}

}

?>